/*
 * Decompiled with CFR 0.152.
 */
package ifc.awt;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.KeyEvent;
import com.sun.star.awt.MouseEvent;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.XKeyHandler;
import com.sun.star.awt.XMouseClickHandler;
import com.sun.star.awt.XUserInputInterception;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XModel;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import java.awt.AWTException;
import java.awt.Robot;
import lib.MultiMethodTest;
import util.AccessibilityTools;
import util.DesktopTools;
import util.utils;

public class _XUserInputInterception
extends MultiMethodTest {
    public XUserInputInterception oObj = null;
    private XModel m_XModel = null;
    private MyMouseClickHandler1 m_MouseListener1 = null;
    private MyMouseClickHandler2 m_MouseListener2 = null;
    private MyKeyHandler1 m_KeyListener1 = null;
    private MyKeyHandler2 m_KeyListener2 = null;
    private boolean m_mousePressed1 = false;
    private boolean m_mouseReleased1 = false;
    private boolean m_mousePressed2 = false;
    private boolean m_mouseReleased2 = false;
    private boolean m_keyPressed1 = false;
    private boolean m_keyReleased1 = false;
    private boolean m_keyPressed2 = false;
    private boolean m_keyReleased2 = false;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleComponent;

    protected void before() {
        this.log.print("try to get object relation 'XUserInputInterception.XModel': ");
        this.m_XModel = (XModel)this.tEnv.getObjRelation("XUserInputInterception.XModel");
        if (this.m_XModel == null) {
            this.log.println("failed => null");
        } else {
            this.log.println("OK");
        }
    }

    public void _addKeyHandler() {
        this.log.println("creating key listener 1");
        this.m_KeyListener1 = new MyKeyHandler1();
        this.log.println("creating key listener 2");
        this.m_KeyListener2 = new MyKeyHandler2();
        this.log.println("adding key listener 1");
        this.oObj.addKeyHandler(this.m_KeyListener1);
        this.log.println("adding key listener 2");
        this.oObj.addKeyHandler(this.m_KeyListener2);
        this.tRes.tested("addKeyHandler()", true);
    }

    public void _removeKeyHandler() {
        this.requiredMethod("addKeyHandler()");
        this.log.println("remove key listener 2");
        this.oObj.removeKeyHandler(this.m_KeyListener2);
        this.log.println("starting thread to check the key listener...");
        EventTrigger eventTrigger = new EventTrigger(this.m_XModel, 2);
        eventTrigger.run();
        utils.shortWait(this.tParam.getInt("ShortWait") * 2);
        this.log.println("key listener thread should be finished.");
        boolean bl = this.m_keyPressed1 & this.m_keyReleased1 & !this.m_keyPressed2 & !this.m_keyReleased2;
        if (!bl) {
            this.log.println("The key listener has not the expectd status:");
            this.log.println("listener\texpected\tgot");
            this.log.println("keyPressed1\ttrue\t" + this.m_keyPressed1);
            this.log.println("keyReleased1\ttrue\t" + this.m_keyReleased1);
            this.log.println("keyPressed2\tfalse\t" + this.m_keyPressed2);
            this.log.println("keyReleased2\tfalse\t" + this.m_keyReleased2);
        }
        this.log.println("remove Key listener 1");
        this.oObj.removeKeyHandler(this.m_KeyListener1);
        this.tRes.tested("removeKeyHandler()", bl);
    }

    public void _addMouseClickHandler() {
        this.log.println("creating mouse listener 1");
        this.m_MouseListener1 = new MyMouseClickHandler1();
        this.log.println("creating mouse listener 2");
        this.m_MouseListener2 = new MyMouseClickHandler2();
        this.log.println("adding mouse listener 1");
        this.oObj.addMouseClickHandler(this.m_MouseListener1);
        this.log.println("adding mouse listener 2");
        this.oObj.addMouseClickHandler(this.m_MouseListener2);
        this.tRes.tested("addMouseClickHandler()", true);
    }

    public void _removeMouseClickHandler() {
        this.requiredMethod("addMouseClickHandler");
        this.log.println("remove mouse listener 2");
        this.oObj.removeMouseClickHandler(this.m_MouseListener2);
        this.log.println("starting thread to check the mouse listener...");
        EventTrigger eventTrigger = new EventTrigger(this.m_XModel, 1);
        eventTrigger.run();
        utils.shortWait(this.tParam.getInt("ShortWait") * 2);
        this.log.println("mouse listener thread should be finished.");
        boolean bl = this.m_mousePressed1 & this.m_mouseReleased1 & !this.m_mousePressed2 & !this.m_mouseReleased2;
        if (!bl) {
            this.log.println("The mouse listener has not the expectd status:");
            this.log.println("listener\t\texpected\tgot");
            this.log.println("mousePressed1\ttrue\t\t" + this.m_mousePressed1);
            this.log.println("mouseReleased1\ttrue\t\t" + this.m_mouseReleased1);
            this.log.println("mousePressed2\tfalse\t\t" + this.m_mousePressed2);
            this.log.println("mouseReleased2\tfalse\t\t" + this.m_mouseReleased2);
        }
        this.log.println("remove mouse listener 1");
        this.oObj.removeMouseClickHandler(this.m_MouseListener1);
        this.tRes.tested("removeMouseClickHandler()", bl);
    }

    protected void after() {
        this.disposeEnvironment();
    }

    private static interface EventTriggerType {
        public static final int MOUSE_KLICK_INTO_DOC = 1;
        public static final int KEY_TEXT_INTO_DOC = 2;
    }

    private class EventTrigger
    extends Thread {
        private final AccessibilityTools at = new AccessibilityTools();
        private int eventType = 0;
        private XModel xModel = null;

        public EventTrigger(XModel xModel, int n) {
            this.xModel = xModel;
            this.eventType = n;
        }

        public void run() {
            switch (this.eventType) {
                case 1: {
                    this.clickIntoDoc();
                    break;
                }
                case 2: {
                    this.clickIntoDoc();
                    this.keyIntoDoc();
                }
            }
        }

        private void clickIntoDoc() {
            try {
                DesktopTools.bringWindowToFromt(this.xModel);
                XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)_XUserInputInterception.this.tParam.getMSF(), this.xModel);
                XAccessible xAccessible = AccessibilityTools.getAccessibleObject(xWindow);
                XAccessibleContext xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)40);
                XAccessibleComponent xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessibleComponent == null ? (class$com$sun$star$accessibility$XAccessibleComponent = _XUserInputInterception.class$("com.sun.star.accessibility.XAccessibleComponent")) : class$com$sun$star$accessibility$XAccessibleComponent, (Object)xAccessibleContext);
                Point point = xAccessibleComponent.getLocationOnScreen();
                Rectangle rectangle = xAccessibleComponent.getBounds();
                try {
                    Robot robot = new Robot();
                    int n = point.X + rectangle.Width / 2;
                    int n2 = point.Y + rectangle.Height / 2;
                    _XUserInputInterception.this.log.println("try to klick into the middle of the document");
                    robot.mouseMove(n, n2);
                    robot.mousePress(16);
                    robot.mouseRelease(16);
                }
                catch (AWTException aWTException) {
                    _XUserInputInterception.this.log.println("couldn't press mouse button");
                }
            }
            catch (Exception exception) {
                _XUserInputInterception.this.log.println("could not click into the scroll bar: " + exception.toString());
            }
        }

        private void keyIntoDoc() {
            try {
                Robot robot = new Robot();
                _XUserInputInterception.this.log.println("try to press 'A'");
                robot.keyPress(65);
                robot.keyRelease(65);
            }
            catch (AWTException aWTException) {
                _XUserInputInterception.this.log.println("couldn't press key");
            }
        }
    }

    public class MyMouseClickHandler2
    implements XMouseClickHandler {
        public boolean mousePressed(MouseEvent mouseEvent) {
            _XUserInputInterception.this.log.println("XMouseClickHandler 2: mousePressed-Event: This should not be happen because listener is removed!");
            _XUserInputInterception.this.m_mousePressed2 = true;
            return true;
        }

        public boolean mouseReleased(MouseEvent mouseEvent) {
            _XUserInputInterception.this.log.println("XMouseClickHandler 2: mouseReleased-Event: This should not be happen because listener is removed!");
            _XUserInputInterception.this.m_mouseReleased2 = true;
            return true;
        }

        public void disposing(EventObject eventObject) {
            _XUserInputInterception.this.log.println("XMouseClickHandler 2: disposing-Event:    This should not be happen because listener is removed!");
        }
    }

    public class MyMouseClickHandler1
    implements XMouseClickHandler {
        public boolean mousePressed(MouseEvent mouseEvent) {
            _XUserInputInterception.this.log.println("XMouseClickHandler 1: mousePressed-Event");
            _XUserInputInterception.this.m_mousePressed1 = true;
            return true;
        }

        public boolean mouseReleased(MouseEvent mouseEvent) {
            _XUserInputInterception.this.log.println("XMouseClickHandler 1: mouseReleased-Event");
            _XUserInputInterception.this.m_mouseReleased1 = true;
            return true;
        }

        public void disposing(EventObject eventObject) {
            _XUserInputInterception.this.log.println("XMouseClickHandler 1: disposing-Event");
        }
    }

    public class MyKeyHandler2
    implements XKeyHandler {
        public boolean keyPressed(KeyEvent keyEvent) {
            _XUserInputInterception.this.log.println("XKeyHandler 2: keyPressed-Event: This should not be happen because listener is removed!");
            _XUserInputInterception.this.m_keyPressed2 = true;
            return true;
        }

        public boolean keyReleased(KeyEvent keyEvent) {
            _XUserInputInterception.this.log.println("XKeyHandler 2: keyReleased-Event: This should not be happen because listener is removed!");
            _XUserInputInterception.this.m_keyReleased2 = true;
            return true;
        }

        public void disposing(EventObject eventObject) {
            _XUserInputInterception.this.log.println("XKeyHandler 2: disposing-Event: This should not be happen because listener is removed!");
        }
    }

    public class MyKeyHandler1
    implements XKeyHandler {
        public boolean keyPressed(KeyEvent keyEvent) {
            _XUserInputInterception.this.log.println("XKeyHandler 1: keyPressed-Event");
            _XUserInputInterception.this.m_keyPressed1 = true;
            return true;
        }

        public boolean keyReleased(KeyEvent keyEvent) {
            _XUserInputInterception.this.log.println("XKeyHandler 1: keyReleased-Event");
            _XUserInputInterception.this.m_keyReleased1 = true;
            return true;
        }

        public void disposing(EventObject eventObject) {
            _XUserInputInterception.this.log.println("XKeyHandler 1: disposing-Event");
        }
    }
}

