/*
 * Decompiled with CFR 0.152.
 */
package helper;

import lib.TestParameters;
import share.LogWriter;
import util.utils;

public class LoggingThread
extends Thread {
    TestParameters param;
    LogWriter log = null;
    boolean finished = false;
    boolean debug = false;

    public LoggingThread(LogWriter logWriter, TestParameters testParameters) {
        this.log = logWriter;
        this.param = testParameters;
        this.debug = testParameters.getBool("DebugIsActive");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int n = this.param.getInt("TimeOut") / 2;
        int n2 = 0;
        this.finished = false;
        if (this.debug) {
            this.log.println("TimeOutLogger: " + utils.getDateTime() + " start");
        }
        while (!this.finished && n2 < 200) {
            try {
                if (this.debug) {
                    this.log.println("TimeOutLogger: " + utils.getDateTime() + n2);
                }
                LoggingThread loggingThread = this;
                synchronized (loggingThread) {
                    this.wait(n);
                }
                ++n2;
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.debug) {
            this.log.println("TimeOutLogger: " + utils.getDateTime() + " finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        try {
            this.finished = true;
            LoggingThread loggingThread = this;
            synchronized (loggingThread) {
                this.notify();
            }
            if (this.debug) {
                this.log.println("TimeOutLogger: " + utils.getDateTime() + " try to finish ");
            }
            LoggingThread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

