/*
 * Decompiled with CFR 0.152.
 */
package helper;

import helper.BuildEnvTools;
import helper.ParameterNotFoundException;
import helper.ProcessHandler;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import lib.TestParameters;
import share.CwsDataExchange;
import share.LogWriter;
import util.utils;

public class CwsDataExchangeImpl
implements CwsDataExchange {
    private final String cwsName;
    private final TestParameters param;
    private final LogWriter log;
    private final BuildEnvTools bet;
    private final boolean mDebug;

    public CwsDataExchangeImpl(String string, TestParameters testParameters, LogWriter logWriter) throws ParameterNotFoundException {
        this.cwsName = string;
        this.param = testParameters;
        this.log = logWriter;
        this.bet = new BuildEnvTools(testParameters, logWriter);
        this.mDebug = testParameters.getBool("DebugIsActive");
    }

    public ArrayList getModules() {
        String[] stringArray = new String[]{"echo cwsquery starts here", "cwsquery modules", "echo cwsquery ends here"};
        ProcessHandler processHandler = this.bet.runCommandsInEnvironmentShell(stringArray, null, true);
        if (this.mDebug) {
            this.log.println("---> Output of getModules:");
            this.log.println(processHandler.getOutputText());
            this.log.println("<--- Output of getModules");
            this.log.println("---> Error output of getModules");
            this.log.println(processHandler.getErrorText());
            this.log.println("<--- Error output of getModules");
        }
        String[] stringArray2 = processHandler.getOutputText().split("\n");
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        for (int i = 0; i < stringArray2.length; ++i) {
            String string = stringArray2[i];
            if (string.startsWith("cwsquery ends here")) {
                bl = false;
            }
            if (bl && !string.equals("")) {
                arrayList.add(string);
            }
            if (!string.startsWith("cwsquery starts here")) continue;
            bl = true;
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnoApiCwsStatus(boolean bl) {
        OutputStreamWriter outputStreamWriter = null;
        String string = null;
        try {
            String string2 = bl ? ".PASSED.OK" : ".PASSED.FAILED";
            string = utils.getUsersTempDir() + System.getProperty("file.separator") + "UnoApiCwsStatus." + (String)this.param.get("Version") + "_" + this.param.get("OperatingSystem") + string2 + ".txt";
            outputStreamWriter = new FileWriter(string);
            outputStreamWriter.write(string2);
            outputStreamWriter.flush();
            outputStreamWriter.close();
            String[] stringArray = new String[]{"cwsattach " + string};
            this.bet.runCommandsInEnvironmentShell(stringArray, null, true);
        }
        catch (IOException iOException) {
            System.out.println("ERROR: could not attach file '" + string + "' to cws\n" + iOException.toString());
        }
        finally {
            try {
                outputStreamWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

