/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import com.sun.star.beans.PropertyValue;
import com.sun.star.container.XNameAccess;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStorable;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.sdb.XDocumentDataSource;
import com.sun.star.sdb.XOfficeDatabaseDocument;
import com.sun.star.sdb.XReportDocumentsSupplier;
import com.sun.star.sdb.application.XDatabaseDocumentUI;
import com.sun.star.sdbc.XConnection;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import complexlib.ComplexTestCase;
import convwatch.DB;
import convwatch.DateHelper;
import convwatch.GlobalLogWriter;
import convwatch.PropertyHelper;
import convwatch.TimeHelper;
import helper.OfficeProvider;
import helper.OfficeWatcher;
import helper.URLHelper;
import java.io.File;
import java.util.ArrayList;

public class ReportDesignerTest
extends ComplexTestCase {
    String mTestDocumentPath;
    private static XDesktop m_xDesktop = null;
    private OfficeProvider m_aProvider = null;
    private static XMultiServiceFactory m_xXMultiServiceFactory = null;
    private String m_sMailAddress = null;
    private String m_sParentDistinct = null;
    private static String m_sSourceVersion;
    private static String m_sDestinationVersion;
    private static final int WRITER = 1;
    private static final int CALC = 2;
    private String m_sOutputPath = null;

    public String[] getTestMethodNames() {
        return new String[]{"ReportDesignTest"};
    }

    private void checkIfOfficeExists(String string) {
        String string2 = "";
        int n = string.indexOf("soffice.exe");
        if (n > 0) {
            string2 = string.substring(0, n + 11);
        } else {
            n = string.indexOf("soffice");
            if (n > 0) {
                string2 = string.substring(0, n + 7);
            }
        }
        log.println(string2);
        File file = new File(string2);
        if (!file.exists()) {
            log.println("ERROR: There exists no office installation at given path: '" + string2 + "'");
            System.exit(0);
        }
    }

    public static XDesktop getXDesktop() {
        if (m_xDesktop == null) {
            try {
                XInterface xInterface = (XInterface)m_xXMultiServiceFactory.createInstance("com.sun.star.frame.Desktop");
                m_xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)xInterface);
            }
            catch (Exception exception) {
                log.println("ERROR: uno.Exception caught");
                log.println("Message: " + exception.getMessage());
            }
        }
        return m_xDesktop;
    }

    private void showElements(XNameAccess xNameAccess) {
        if (xNameAccess != null) {
            String[] stringArray = xNameAccess.getElementNames();
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println("Value: [" + i + "] := " + stringArray[i]);
            }
        } else {
            System.out.println("Warning: Given object is null.");
        }
    }

    private void startOffice() {
        param.put("TimeOut", new Integer(300000));
        System.out.println("TimeOut: " + param.getInt("TimeOut"));
        System.out.println("ThreadTimeOut: " + param.getInt("ThreadTimeOut"));
        this.m_aProvider = new OfficeProvider();
        m_xXMultiServiceFactory = (XMultiServiceFactory)this.m_aProvider.getManager(param);
        param.put("ServiceFactory", m_xXMultiServiceFactory);
    }

    private void stopOffice() {
        if (this.m_aProvider != null) {
            this.m_aProvider.closeExistingOffice(param, true);
            this.m_aProvider = null;
        }
        TimeHelper.waitInSeconds(2, "Give close Office some time.");
    }

    public void ReportDesignTest() {
        GlobalLogWriter.set(log);
        GlobalLogWriter.get().println("Set office watcher");
        OfficeWatcher officeWatcher = (OfficeWatcher)param.get("Watcher");
        GlobalLogWriter.get().setWatcher(officeWatcher);
        try {
            String string = (String)param.get("AppExecutionCommand");
            String string2 = System.getProperty("user.name");
            log.println("user.name='" + string2 + "'");
            this.m_sMailAddress = System.getProperty("MailAddress");
            log.println("Assumed mail address: " + this.m_sMailAddress);
            this.m_sParentDistinct = System.getProperty("ParentDistinct");
            m_sSourceVersion = System.getProperty("SourceVersion");
            m_sDestinationVersion = System.getProperty("DestinationVersion");
            if (m_sSourceVersion == null) {
                System.out.println("Error, Sourceversion is null.");
                System.exit(1);
            }
            string = string.replaceAll("\\$\\{USERNAME\\}", string2);
            log.println("sAppExecutionCommand='" + string + "'");
            this.checkIfOfficeExists(string);
            param.put("AppExecutionCommand", new String(string));
            this.startOffice();
            String string3 = (String)param.get("DOC_COMPARATOR_INPUT_PATH");
            this.startTestForFile(string3);
        }
        catch (ComplexTestCase.AssureException assureException) {
            this.stopOffice();
            throw new ComplexTestCase.AssureException(assureException.getMessage());
        }
        this.stopOffice();
    }

    private void startTestForFile(String string) {
        File file = new File(string);
        this.assure("Test File doesn't '" + string + "'exist.", file.exists());
        String string2 = URLHelper.getFileURLFromSystemPath(string);
        log.println("File URL: " + string2);
        XComponent xComponent = this.loadComponent(string2, ReportDesignerTest.getXDesktop(), null);
        log.println("Load done");
        try {
            XInterface xInterface = (XInterface)m_xXMultiServiceFactory.createInstance("com.sun.star.sdb.DatabaseContext");
            this.assure("can't create instance of com.sun.star.sdb.DatabaseContext", xInterface != null);
            log.println("createInstance com.sun.star.sdb.DatabaseContext done");
            XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)xInterface);
            this.showElements(xNameAccess);
            Object object = xNameAccess.getByName(string2);
            XDocumentDataSource xDocumentDataSource = (XDocumentDataSource)UnoRuntime.queryInterface(XDocumentDataSource.class, object);
            XOfficeDatabaseDocument xOfficeDatabaseDocument = xDocumentDataSource.getDatabaseDocument();
            this.assure("can't access DatabaseDocument", xOfficeDatabaseDocument != null);
            XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xOfficeDatabaseDocument);
            XController xController = xModel.getCurrentController();
            this.assure("Controller of xOfficeDatabaseDocument is empty!", xController != null);
            XDatabaseDocumentUI xDatabaseDocumentUI = (XDatabaseDocumentUI)UnoRuntime.queryInterface(XDatabaseDocumentUI.class, (Object)xController);
            boolean bl = xDatabaseDocumentUI.connect();
            XConnection xConnection = xDatabaseDocumentUI.getActiveConnection();
            this.assure("ActiveConnection is empty", xConnection != null);
            XReportDocumentsSupplier xReportDocumentsSupplier = (XReportDocumentsSupplier)UnoRuntime.queryInterface(XReportDocumentsSupplier.class, (Object)xOfficeDatabaseDocument);
            xNameAccess = xReportDocumentsSupplier.getReportDocuments();
            this.assure("xOfficeDatabaseDocument returns no Report Document", xNameAccess != null);
            this.showElements(xNameAccess);
            ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
            PropertyValue propertyValue = new PropertyValue();
            propertyValue.Name = "ActiveConnection";
            propertyValue.Value = xConnection;
            arrayList.add(propertyValue);
            this.loadAndStoreReports(xNameAccess, arrayList);
            this.createDBEntry();
        }
        catch (Exception exception) {
            log.println("ERROR: Exception caught");
            log.println("Message: " + exception.getMessage());
        }
        this.closeComponent(xComponent);
    }

    private String getDocumentPoolName() {
        return "AutogenReportDesignTest";
    }

    private void createDBEntry() {
        String string;
        String string2 = (String)param.get("DB_CONNECTION_STRING");
        log.println("DBConnection: " + string2);
        DB.init(string2);
        String string3 = string = "ReportDesignFixRef";
        String string4 = "";
        String string5 = "fixref";
        String string6 = m_sDestinationVersion;
        String string7 = "";
        String string8 = "";
        String string9 = this.getOutputPath();
        String string10 = this.getDocumentPoolName();
        String string11 = "";
        DB.insertinto_documentcompare(string3, string4, string5, m_sDestinationVersion, string7, string8, string9, string10, this.m_sMailAddress, string11, this.m_sParentDistinct);
        TimeHelper.waitInSeconds(1, "wait for DB.");
    }

    private void loadAndStoreReports(XNameAccess xNameAccess, ArrayList arrayList) {
        if (xNameAccess != null) {
            String[] stringArray = xNameAccess.getElementNames();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                XComponent xComponent = this.loadComponent(string, xNameAccess, arrayList);
                this.storeComponent(string, xComponent);
                this.closeComponent(xComponent);
            }
        }
    }

    private String getFormatExtension(Object object) {
        XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, object);
        String string = xServiceInfo.supportsService("com.sun.star.sheet.SpreadsheetDocument") ? ".ods" : (xServiceInfo.supportsService("com.sun.star.text.TextDocument") ? ".odt" : ".UNKNOWN");
        return string;
    }

    private String getOutputPath() {
        if (this.m_sOutputPath == null) {
            String string = (String)param.get("DOC_COMPARATOR_OUTPUT_PATH");
            if (!string.endsWith("/") || !string.endsWith("\\")) {
                string = string + System.getProperty("file.separator");
            }
            string = string + DateHelper.getDateTimeForFilename();
            string = string + System.getProperty("file.separator");
            File file = new File(string);
            file.mkdirs();
            this.m_sOutputPath = string;
        }
        return this.m_sOutputPath;
    }

    private void storeComponent(String string, Object object) {
        String string2 = this.getOutputPath();
        string2 = string2 + this.getDocumentPoolName();
        string2 = string2 + System.getProperty("file.separator");
        File file = new File(string2);
        file.mkdirs();
        string2 = string2 + string;
        string2 = string2 + this.getFormatExtension(object);
        String string3 = URLHelper.getFileURLFromSystemPath(string2);
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.Name = "Overwrite";
        propertyValue.Value = Boolean.TRUE;
        arrayList.add(propertyValue);
        XStorable xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, object);
        if (xStorable != null) {
            log.println("store document as URL: '" + string3 + "'");
            try {
                xStorable.storeAsURL(string3, PropertyHelper.createPropertyValueArrayFormArrayList(arrayList));
            }
            catch (IOException iOException) {
                log.println("ERROR: Exception caught");
                log.println("Can't write document URL: '" + string3 + "'");
                log.println("Message: " + iOException.getMessage());
            }
        }
    }

    private XComponent loadComponent(String string, Object object, ArrayList arrayList) {
        XComponent xComponent = null;
        XComponentLoader xComponentLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, object);
        try {
            PropertyValue[] propertyValueArray = PropertyHelper.createPropertyValueArrayFormArrayList(arrayList);
            log.println("Load component: '" + string + "'");
            xComponent = xComponentLoader.loadComponentFromURL(string, "_blank", 0, propertyValueArray);
        }
        catch (IOException iOException) {
            log.println("ERROR: Exception caught");
            log.println("Can't load document '" + string + "'");
            log.println("Message: " + iOException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.println("ERROR: Exception caught");
            log.println("Illegal Arguments given to loadComponentFromURL.");
            log.println("Message: " + illegalArgumentException.getMessage());
        }
        return xComponent;
    }

    private void closeComponent(XComponent xComponent) {
        XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)xComponent);
        try {
            xCloseable.close(true);
        }
        catch (CloseVetoException closeVetoException) {
            log.println("ERROR: CloseVetoException caught");
            log.println("CloseVetoException occured Can't close document.");
            log.println("Message: " + closeVetoException.getMessage());
        }
    }
}

