/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import convwatch.GlobalLogWriter;
import convwatch.OSHelper;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import util.utils;

public class FileHelper {
    private static boolean m_bDebugTextShown = false;

    public FileHelper() {
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("os.arch");
        String string3 = System.getProperty("os.version");
        GlobalLogWriter.get().println(string);
        GlobalLogWriter.get().println(string2);
        GlobalLogWriter.get().println(string3);
    }

    public static void MessageBox(String string) {
        String string2 = System.getProperty("java.version");
        String string3 = System.getProperty("os.name");
        JOptionPane.showMessageDialog(null, string, string2 + " " + string3 + " Hello World Debugger", 1);
    }

    public static boolean exists(String string) {
        if (string == null) {
            return false;
        }
        File file = new File(string);
        return file.exists();
    }

    public static boolean isDir(String string) {
        if (string == null) {
            return false;
        }
        try {
            File file = new File(string);
            if (file.exists() && file.isDirectory()) {
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            GlobalLogWriter.get().println("Exception caught. FileHelper.isDir('" + string + "')");
            nullPointerException.printStackTrace();
        }
        return false;
    }

    public static String getBasename(String string) {
        if (string == null) {
            return "";
        }
        String string2 = System.getProperty("file.separator");
        int n = string.lastIndexOf(string2);
        if (n > 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static String getNameNoSuffix(String string) {
        if (string == null) {
            return "";
        }
        int n = string.lastIndexOf(".");
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String getSuffix(String string) {
        if (string == null) {
            return "";
        }
        int n = string.lastIndexOf(".");
        if (n > 0) {
            return string.substring(n);
        }
        return "";
    }

    public static String getPath(String string) {
        if (string == null) {
            return "";
        }
        String string2 = System.getProperty("file.separator");
        int n = string.lastIndexOf(string2);
        if (n > 0) {
            return string.substring(0, n);
        }
        return "";
    }

    public static void makeDirectories(String string, String string2) {
        FileHelper.makeDirectories(string, string2, "0777");
    }

    public static void makeDirectories(String string, String string2, String string3) {
        String string4 = System.getProperty("file.separator");
        if (string2.startsWith(string4 + string4)) {
            int n = string2.indexOf(string4, 2);
            n = string2.indexOf(string4, n + 1);
            string = string2.substring(0, n);
            string2 = string2.substring(n + 1);
        }
        String string5 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string4, false);
        string5 = string;
        while (stringTokenizer.hasMoreTokens()) {
            String string6 = stringTokenizer.nextToken();
            File file = new File(string5 + File.separatorChar + string6);
            string5 = file.toString();
            file.mkdirs();
            if (!OSHelper.isUnix() || string3.length() <= 0) continue;
            try {
                FileHelper.chmod(file, string3);
            }
            catch (IOException iOException) {
                GlobalLogWriter.get().println("Exception caught. FileHelper.makeDirectories('" + file.getAbsolutePath() + "')");
            }
        }
    }

    public static void chmod(File file, String string) throws IOException {
        Runtime.getRuntime().exec(new String[]{"chmod", string, file.getAbsolutePath()});
    }

    public static String removeFirstDirectorysAndBasenameFrom(String string, String string2) {
        String string3 = System.getProperty("file.separator");
        String string4 = FileHelper.getBasename(string);
        String string5 = "";
        if (string.startsWith(string2)) {
            int n;
            int n2 = string2.length();
            if (!string2.endsWith(string3)) {
                ++n2;
            }
            if (n2 < (n = string.length() - string4.length() - 1)) {
                string5 = string.substring(n2, n);
            }
        } else {
            string5 = FileHelper.getPath(string);
            if (string5.startsWith(string3)) {
                string5 = string5.substring(1);
            }
        }
        return string5;
    }

    public static void test_removeFirstDirectorysAndBasenameFrom() {
        String string = FileHelper.removeFirstDirectorysAndBasenameFrom("/a/b/c/d/e/f.g", "/a/b/c");
        String string2 = FileHelper.removeFirstDirectorysAndBasenameFrom("/a/b/c/d/e/f.g", "/a/b/c/");
        String string3 = FileHelper.removeFirstDirectorysAndBasenameFrom("/a/b/c/d/e/f.g", "/b/c");
    }

    public static String getSystemPathFromFileURL(String string) {
        String string2 = null;
        if (string.startsWith("file:///")) {
            string2 = OSHelper.isWindows() ? string.substring(8) : string.substring(7);
        } else if (string.startsWith("file://")) {
            string2 = string.substring(5);
        }
        String string3 = System.getProperty("file.separator");
        if (!string3.equals("/")) {
            string2 = string2.replace('/', string3.toCharArray()[0]);
        }
        return string2;
    }

    public static boolean isDebugEnabled() {
        boolean bl = false;
        String string = utils.getUsersTempDir();
        String string2 = System.getProperty("file.separator");
        String string3 = string + string2 + "DOC_COMPARATOR_DEBUG";
        File file = new File(string3);
        if (file.exists()) {
            if (!m_bDebugTextShown) {
                GlobalLogWriter.get().println("Found file: " + string3);
                GlobalLogWriter.get().println("Activate debug mode.");
                GlobalLogWriter.get().println("If debug mode is no longer necessary, remove the above file.");
                m_bDebugTextShown = true;
            }
            bl = true;
        }
        return bl;
    }

    public static void copy(String string, String string2) {
        try {
            int n;
            File file = new File(string);
            File file2 = new File(string2);
            FileReader fileReader = new FileReader(file);
            FileWriter fileWriter = new FileWriter(file2);
            while ((n = fileReader.read()) != -1) {
                fileWriter.write(n);
            }
            fileReader.close();
            fileWriter.close();
        }
        catch (IOException iOException) {
            GlobalLogWriter.get().println("Exception caught. FileHelper.copy('" + string + ", " + string2 + "')");
            GlobalLogWriter.get().println("Message: " + iOException.getMessage());
        }
    }
}

