/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import convwatch.DBHelper;
import convwatch.GlobalLogWriter;
import convwatch.OSHelper;
import convwatch.ShareConnection;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class DB
extends DBHelper {
    private static DB m_aDB = null;
    private String m_sSourceVersion;
    private String m_sDestinationVersion;
    private String m_sDocumentPool;
    private String m_sEnvironment;
    private String m_sDocID;
    private String m_sDBDistinct;

    private DB() {
    }

    private static synchronized DB getDB() {
        if (m_aDB == null) {
            m_aDB = new DB();
        }
        return m_aDB;
    }

    public static void init(String string) {
        if (string == null) {
            return;
        }
        DB.getDB().fillVariables(string);
        DB.getDB().updatestate_status("source started");
    }

    public static void test() {
        DB.getDB().sql_test();
    }

    public static void source_start() {
        DB.getDB().updatestate_status("source started");
    }

    public static void source_finished() {
        DB.getDB().updatestate_status("source finished");
    }

    public static void source_failed(String string) {
        DB.getDB().updatestate_status("source failed");
        DB.getDB().updateinfo_status(string);
    }

    public static void destination_start() {
        DB.getDB().updatestate_status("destination started");
    }

    public static void destination_finished() {
        DB.getDB().updatestate_status("PASSED-OK");
    }

    public static void destination_failed(String string, String string2) {
        DB.getDB().updatestate_status(string);
        DB.getDB().updateinfo_status(string2);
    }

    public static void writeNumberOfPages(int n) {
        DB.getDB().updatepagecount_documents(n);
    }

    public static void writeErrorFile(String string) {
        DB.getDB().updateerrorfile_status(string);
    }

    public static void writeHTMLFile(String string) {
        DB.getDB().updatehtmlfile_status(string);
    }

    public static void writeToDB(String string, String string2, String string3, String string4, String string5, int n) {
        GlobalLogWriter.get().println("DB:   Filename:" + string);
        GlobalLogWriter.get().println("DB:   Basename:" + string2);
        GlobalLogWriter.get().println("DB: FileFormat:" + string3);
        GlobalLogWriter.get().println("DB:    BuildID:" + string4);
        GlobalLogWriter.get().println("DB: SourceType:" + string5);
        GlobalLogWriter.get().println("DB: Resolution:" + n);
    }

    private String getEnvironment() {
        if (OSHelper.isWindows()) {
            return "wntmsci";
        }
        if (OSHelper.isSolarisIntel()) {
            return "unxsoli";
        }
        if (OSHelper.isSolarisSparc()) {
            return "unxsols";
        }
        if (OSHelper.isLinuxIntel()) {
            return "unxlngi";
        }
        GlobalLogWriter.get().println("DB: Unknown environment.");
        GlobalLogWriter.get().println("DB: os.name := " + System.getProperty("os.name").toLowerCase());
        GlobalLogWriter.get().println("DB: os.arch := " + System.getProperty("os.arch"));
        return "";
    }

    private void fillVariables(String string) {
        this.fillDBConnection(string);
        this.m_sEnvironment = this.getEnvironment();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("p:")) {
                this.m_sSourceVersion = string2.substring(2);
                GlobalLogWriter.get().println("DB: source version: " + this.m_sSourceVersion);
                continue;
            }
            if (string2.startsWith("src:")) {
                this.m_sSourceVersion = string2.substring(4);
                GlobalLogWriter.get().println("DB: source version: " + this.m_sSourceVersion);
                continue;
            }
            if (string2.startsWith("c:")) {
                this.m_sDestinationVersion = string2.substring(2);
                GlobalLogWriter.get().println("DB: destination version: " + this.m_sDestinationVersion);
                continue;
            }
            if (string2.startsWith("dest:")) {
                this.m_sDestinationVersion = string2.substring(5);
                GlobalLogWriter.get().println("DB: destination version: " + this.m_sDestinationVersion);
                continue;
            }
            if (string2.startsWith("d:")) {
                this.m_sDocumentPool = string2.substring(2);
                GlobalLogWriter.get().println("DB: documentpool version: " + this.m_sDocumentPool);
                continue;
            }
            if (string2.startsWith("doc:")) {
                this.m_sDocumentPool = string2.substring(4);
                GlobalLogWriter.get().println("DB: documentpool version: " + this.m_sDocumentPool);
                continue;
            }
            if (string2.startsWith("id:")) {
                this.m_sDocID = string2.substring(3);
                GlobalLogWriter.get().println("DB: docid: " + this.m_sDocID);
                continue;
            }
            if (!string2.startsWith("distinct:")) continue;
            this.m_sDBDistinct = string2.substring(9);
            GlobalLogWriter.get().println("DB: distinct: " + this.m_sDBDistinct);
        }
    }

    private void sql_test() {
        String string = this.getDBDistinct();
        System.out.println("UUID: " + string);
    }

    public ArrayList QuerySQL(Connection connection, String string) {
        Statement statement = null;
        Object var4_4 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            while (resultSet.next()) {
                StringBuffer stringBuffer = new StringBuffer();
                try {
                    Object var10_12 = null;
                    stringBuffer.append("sqlresult: ");
                    for (int i = 1; i <= n; ++i) {
                        String string2;
                        String string3 = resultSetMetaData.getColumnName(i);
                        stringBuffer.append(string3).append("=");
                        int n2 = resultSetMetaData.getColumnType(i);
                        switch (n2) {
                            case 12: {
                                string2 = "'" + resultSet.getString(i) + "'";
                                break;
                            }
                            case 4: {
                                int n3 = resultSet.getInt(i);
                                string2 = String.valueOf(n3);
                                break;
                            }
                            default: {
                                string2 = "UNSUPPORTED TYPE";
                            }
                        }
                        stringBuffer.append(string2).append(", ");
                    }
                    String string4 = stringBuffer.toString();
                    arrayList.add(string4);
                }
                catch (SQLException sQLException) {}
            }
        }
        catch (SQLException sQLException) {
            String string5 = sQLException.getMessage();
            GlobalLogWriter.get().println("DB: Original SQL error: " + string5);
        }
        return arrayList;
    }

    private void updatestate_status(String string) {
        Connection connection = new ShareConnection().getConnection();
        String string2 = "state=" + this.Quote(string);
        String string3 = this.getWhereClause();
        if (string3.length() > 0) {
            this.SQLupdateValue(connection, "status", string2, string3);
        }
    }

    private void updateinfo_status(String string) {
        Connection connection = new ShareConnection().getConnection();
        String string2 = "info=" + this.Quote(string);
        String string3 = this.getWhereClause();
        this.SQLupdateValue(connection, "status", string2, string3);
    }

    private void updateerrorfile_status(String string) {
        Connection connection = new ShareConnection().getConnection();
        String string2 = string.replace('\\', '/');
        String string3 = "errorfile=" + this.Quote(string2);
        String string4 = this.getWhereClause();
        this.SQLupdateValue(connection, "status", string3, string4);
    }

    private void updatehtmlfile_status(String string) {
        Connection connection = new ShareConnection().getConnection();
        String string2 = string.replace('\\', '/');
        String string3 = "htmlfile=" + this.Quote(string2);
        String string4 = this.getWhereClause();
        this.SQLupdateValue(connection, "status", string3, string4);
    }

    private void updatepagecount_documents(int n) {
        Connection connection = new ShareConnection().getConnection();
        String string = "pagecount=" + n;
        String string2 = this.getWhereClause();
        this.SQLupdateValue(connection, "documents", string, string2);
    }

    private String getWhereClause() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (this.m_sDocID != null) {
            stringBuffer.append("docid").append("=").append(this.m_sDocID);
            bl = true;
        }
        if (bl) {
            stringBuffer.append(" AND ");
        }
        if (this.m_sDBDistinct != null) {
            stringBuffer.append("dbdistinct2").append("=").append(this.Quote(this.m_sDBDistinct));
        }
        return stringBuffer.toString();
    }

    private String getDBDistinct() {
        Connection connection = new ShareConnection().getConnection();
        String string = "SELECT uuid()";
        ArrayList arrayList = this.QuerySQL(connection, string);
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = (String)arrayList.get(i);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",", false);
            if (!stringTokenizer.hasMoreTokens()) continue;
            String string3 = stringTokenizer.nextToken();
            int n = string3.indexOf("uuid()=");
            int n2 = string3.indexOf("'", n);
            int n3 = string3.lastIndexOf("'");
            String string4 = string3.substring(n2 + 1, n3);
            return string4;
        }
        return "0";
    }

    public static void insertinto_documentcompare(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11) {
        DB.getDB().insertinto_documentcompare_impl(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11);
    }

    private void insertinto_documentcompare_impl(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11) {
        if (string11 == null) {
            string11 = "";
        }
        Connection connection = new ShareConnection().getConnection();
        String string12 = "dbdistinct2, environment, sourceversion, sourcename, sourcecreatortype, destinationversion, destinationname, destinationcreatortype, documentpoolpath, documentpool, mailfeedback, state, special, parentdistinct, startdate";
        String string13 = string7.replace('\\', '/');
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.Quote(this.getDBDistinct())).append(",").append(this.Quote(this.getEnvironment())).append(",").append(this.Quote(string)).append(",").append(this.Quote(string2)).append(",").append(this.Quote(string3)).append(",").append(this.Quote(string4)).append(",").append(this.Quote(string5)).append(",").append(this.Quote(string6)).append(",").append(this.Quote(string13)).append(",").append(this.Quote(string8)).append(",").append(this.Quote(string9)).append(",").append(this.Quote("new")).append(",").append(this.Quote(string10)).append(",").append(this.Quote(string11)).append(",").append(this.Quote(DB.today()));
        this.SQLinsertValues(connection, "documentcompare", string12, stringBuffer.toString());
    }
}

