/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import convwatch.ConvWatchCancelException;
import convwatch.ConvWatchException;
import convwatch.DB;
import convwatch.FileHelper;
import convwatch.GlobalLogWriter;
import convwatch.GraphicalTestArguments;
import convwatch.INIOutputter;
import convwatch.IniFile;
import convwatch.OfficePrint;
import convwatch.PRNCompare;
import convwatch.StatusHelper;
import convwatch.TriState;
import helper.URLHelper;
import java.io.File;

public class ConvWatch {
    String getBuildID_FromFile(String string) {
        String string2 = "";
        IniFile iniFile = new IniFile(string);
        if (iniFile.is()) {
            string2 = iniFile.getValue("", "buildid");
        }
        return string2;
    }

    StatusHelper[] createPostscriptStartCheck(GraphicalTestArguments graphicalTestArguments, String string, String string2, String string3) throws ConvWatchCancelException {
        String string4;
        Object object;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        if (!FileHelper.exists(string2)) {
            throw new ConvWatchCancelException("createPostscriptStartCheck: Input file: " + string2 + " does not exist.");
        }
        if (string3 == null) {
            string9 = FileHelper.getNameNoSuffix(string2);
            string3 = string9 + ".prn";
        }
        string9 = System.getProperty("file.separator");
        File file = new File(string3);
        if (file.isDirectory()) {
            string8 = FileHelper.getBasename(string2);
            string7 = FileHelper.getNameNoSuffix(string8);
            string6 = string3 + string9 + string7 + ".info";
            string3 = string3 + string9 + string7 + ".prn";
            string5 = "";
            if (FileHelper.exists(string6)) {
                string5 = this.getBuildID_FromFile(string6);
            }
            graphicalTestArguments.setRefBuildID(string5);
        } else {
            string8 = FileHelper.getBasename(string3);
            int n = string8.indexOf(46);
            if (n == -1) {
                throw new ConvWatchCancelException("createPostscriptStartCheck: Given reference directory: '" + string3 + "' does not exist.");
            }
        }
        boolean bl = true;
        if (!FileHelper.exists(string3)) {
            if (graphicalTestArguments.createDefaultReference()) {
                GlobalLogWriter.get().println("Reference File doesn't exist, will create a default");
                bl = false;
            } else {
                throw new ConvWatchCancelException("createPostscriptStartCheck: Given reference file: " + string3 + " does not exist.");
            }
        }
        FileHelper.makeDirectories("", string);
        string7 = URLHelper.getFileURLFromSystemPath(string2);
        string6 = FileHelper.getBasename(string2);
        string5 = FileHelper.getNameNoSuffix(string6);
        String string10 = string + string9 + string6;
        String string11 = URLHelper.getFileURLFromSystemPath(string10);
        String string12 = FileHelper.getBasename(string3);
        String string13 = FileHelper.getNameNoSuffix(string12);
        String string14 = string13 + ".ps";
        String string15 = string + string9 + string14;
        String string16 = URLHelper.getFileURLFromSystemPath(string15);
        OfficePrint.printToFile(graphicalTestArguments, string7, string11, string16);
        if (!FileHelper.exists(string15)) {
            throw new ConvWatchCancelException("createPostscriptStartCheck: Printed file " + string15 + " does not exist.");
        }
        if (!bl) {
            object = string15;
            string4 = string3;
            FileHelper.copy((String)object, string4);
            if (!FileHelper.exists(string3)) {
                throw new ConvWatchCancelException("createPostscriptStartCheck: Given reference file: " + string3 + " does not exist, after try to copy.");
            }
        }
        object = new PRNCompare();
        string4 = FileHelper.getPath(string2);
        String string17 = FileHelper.getPath(string3);
        ((PRNCompare)object).setInputPath(string4);
        ((PRNCompare)object).setReferencePath(string17);
        ((PRNCompare)object).setOutputPath(string);
        ((PRNCompare)object).setReferenceFile(string12);
        ((PRNCompare)object).setPostScriptFile(string14);
        if (graphicalTestArguments.printAllPages()) {
            ((PRNCompare)object).setMaxPages(9999);
        } else {
            if (graphicalTestArguments.getMaxPages() > 0) {
                ((PRNCompare)object).setMaxPages(graphicalTestArguments.getMaxPages());
            }
            if (graphicalTestArguments.getOnlyPages().length() != 0) {
                ((PRNCompare)object).setMaxPages(9999);
            }
        }
        ((PRNCompare)object).setResolutionInDPI(graphicalTestArguments.getResolutionInDPI());
        ((PRNCompare)object).setBorderMove(graphicalTestArguments.getBorderMove());
        ((PRNCompare)object).setDocumentType(graphicalTestArguments.getDocumentType());
        StatusHelper[] statusHelperArray = ((PRNCompare)object).compare();
        graphicalTestArguments.setBorderMove(((PRNCompare)object).getBorderMove());
        return statusHelperArray;
    }

    static boolean createINIStatus(StatusHelper[] statusHelperArray, String string, String string2, String string3, String string4, String string5) {
        String string6 = System.getProperty("file.separator");
        String string7 = FileHelper.getBasename(string3);
        String string8 = FileHelper.getNameNoSuffix(string7);
        String string9 = string + string8 + ".ini";
        INIOutputter iNIOutputter = INIOutputter.create(string2, string9, "", "");
        iNIOutputter.createHeader();
        iNIOutputter.writeSection("global");
        iNIOutputter.writeValue("pages", String.valueOf(statusHelperArray.length));
        iNIOutputter.writeValue("buildid", string4);
        iNIOutputter.writeValue("refbuildid", string5);
        iNIOutputter.writeValue("diffdiff", "no");
        iNIOutputter.writeValue("basename", string7);
        boolean bl = true;
        for (int i = 0; i < statusHelperArray.length; ++i) {
            iNIOutputter.writeSection("page" + String.valueOf(i + 1));
            statusHelperArray[i].printStatus();
            boolean bl2 = true;
            int n = statusHelperArray[i].nDiffStatus;
            if (!(n == 2 || n == 3 && statusHelperArray[i].nPercent < 5 || n == 4 || n == 5 && statusHelperArray[i].nPercent2 < 5)) {
                bl2 = false;
            }
            iNIOutputter.checkLine(statusHelperArray[i], bl2);
            bl &= bl2;
        }
        iNIOutputter.close();
        return bl;
    }

    static void createINIStatus_DiffDiff(StatusHelper[] statusHelperArray, String string, String string2, String string3, String string4) {
        String string5 = System.getProperty("file.separator");
        String string6 = FileHelper.getBasename(string3);
        String string7 = FileHelper.getNameNoSuffix(string6);
        String string8 = string + string7 + ".ini";
        INIOutputter iNIOutputter = INIOutputter.create(string2, string8, string, "");
        iNIOutputter.createHeader();
        iNIOutputter.writeSection("global");
        iNIOutputter.writeValue("pages", String.valueOf(statusHelperArray.length));
        iNIOutputter.writeValue("buildid", string4);
        iNIOutputter.writeValue("diffdiff", "yes");
        iNIOutputter.writeValue("basename", string6);
        for (int i = 0; i < statusHelperArray.length; ++i) {
            iNIOutputter.writeSection("page" + String.valueOf(i + 1));
            boolean bl = statusHelperArray[i].nDiffStatus == 2;
            iNIOutputter.checkDiffDiffLine(statusHelperArray[i], bl);
        }
        iNIOutputter.close();
    }

    public static boolean check(GraphicalTestArguments graphicalTestArguments, String string, String string2, String string3) throws ConvWatchCancelException, ConvWatchException {
        ConvWatch convWatch = new ConvWatch();
        StatusHelper[] statusHelperArray = convWatch.createPostscriptStartCheck(graphicalTestArguments, string, string2, string3);
        DB.writeNumberOfPages(statusHelperArray.length);
        boolean bl = ConvWatch.createINIStatus(statusHelperArray, "", string, string2, graphicalTestArguments.getBuildID(), graphicalTestArguments.getRefBuildID());
        if (!bl) {
            String string4 = "Graphical compare failed with file ";
            String string5 = string2.replace('\\', '/');
            string4 = string4 + "'" + string5 + "'";
            DB.writeErrorFile(string5);
            throw new ConvWatchException(string4);
        }
        return bl;
    }

    public static boolean checkDiffDiff(GraphicalTestArguments graphicalTestArguments, String string, String string2, String string3, String string4) throws ConvWatchCancelException, ConvWatchException {
        ConvWatch convWatch = new ConvWatch();
        graphicalTestArguments.setBorderMove(TriState.FALSE);
        StatusHelper[] statusHelperArray = convWatch.createPostscriptStartCheck(graphicalTestArguments, string, string2, string3);
        boolean bl = ConvWatch.createINIStatus(statusHelperArray, "", string, string2, graphicalTestArguments.getBuildID(), graphicalTestArguments.getRefBuildID());
        StatusHelper[] statusHelperArray2 = new StatusHelper[statusHelperArray.length];
        String string5 = System.getProperty("file.separator");
        boolean bl2 = true;
        boolean bl3 = false;
        PRNCompare pRNCompare = new PRNCompare();
        for (int i = 0; i < statusHelperArray.length; ++i) {
            String string6 = statusHelperArray[i].m_sDiffGfx;
            String string7 = FileHelper.getBasename(string6);
            String string8 = string4 + string5 + string7;
            if (!FileHelper.exists(string8)) {
                GlobalLogWriter.get().println("checkDiffDiff: Old diff file: '" + string8 + "' does not exist.");
                continue;
            }
            String string9 = FileHelper.getPath(string6);
            String string10 = string7;
            String string11 = string4;
            String string12 = string7;
            StatusHelper statusHelper = pRNCompare.checkDiffDiff(string, string9, string10, string11, string12);
            boolean bl4 = statusHelper.nDiffStatus == 2;
            bl2 &= bl4;
            bl3 = true;
            statusHelperArray2[i] = statusHelper;
        }
        ConvWatch.createINIStatus_DiffDiff(statusHelperArray2, "DiffDiff_", string, string2, graphicalTestArguments.getBuildID());
        if (!bl3) {
            throw new ConvWatchCancelException("No old difference file found.");
        }
        if (!bl2) {
            throw new ConvWatchException("Graphical difference compare failed with file '" + string2 + "'");
        }
        return bl2;
    }
}

