/*
 * Decompiled with CFR 0.152.
 */
package complex.unoapi;

import base.java_complex;
import com.sun.star.lang.XMultiServiceFactory;
import complexlib.ComplexTestCase;
import helper.BuildEnvTools;
import helper.ComplexDescGetter;
import helper.CwsDataExchangeImpl;
import helper.OfficeProvider;
import helper.ParameterNotFoundException;
import helper.ProcessHandler;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import share.DescEntry;
import util.utils;

public class CheckModuleAPI
extends ComplexTestCase {
    private String mSRC_ROOT = null;
    private boolean mIsInitialized = false;
    private static final boolean mContinue = true;
    private boolean mDebug = false;
    private BuildEnvTools bet = null;

    public void before() {
        if (!this.mIsInitialized) {
            this.mIsInitialized = true;
            try {
                this.bet = new BuildEnvTools(param, log);
            }
            catch (ParameterNotFoundException parameterNotFoundException) {
                this.failed(parameterNotFoundException.toString(), false);
            }
            this.mSRC_ROOT = this.bet.getSrcRoot();
            this.mDebug = param.getBool("DebugIsActive");
            try {
                OfficeProvider officeProvider = new OfficeProvider();
                log.println("Receiving the ServiceManager of the Office to create User installation...");
                int n = param.getInt("TimeOut");
                param.put("TimeOut", new Integer(4 * n));
                XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)officeProvider.getManager(param);
                officeProvider.backupUserLayer(param, xMultiServiceFactory);
                param.put("TimeOut", new Integer(n));
                if (xMultiServiceFactory == null) {
                    this.failed("Could not connect the office");
                }
            }
            catch (Throwable throwable) {
                this.failed("Could not start office " + throwable.toString());
            }
        }
    }

    public void checkModule(String string) {
        log.println(utils.getDateTime() + ": start testing module '" + string + "'");
        log.println(utils.getDateTime() + "start new Office instance...");
        OfficeProvider officeProvider = new OfficeProvider();
        log.println(utils.getDateTime() + "Receiving the ServiceManager of the Office ");
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)officeProvider.getManager(param);
        this.assure("couldnot get ServiceFarcotry", xMultiServiceFactory != null, true);
        param.put("ServiceFactory", xMultiServiceFactory);
        String string2 = System.getProperty("file.separator");
        String string3 = this.getModulePath(string);
        File file = new File(string3);
        String string4 = string3 + string2 + "makefile.mk";
        File file2 = new File(string4);
        this.assure("ERROR: could not find makefile: '" + string4 + "'", file2.exists(), true);
        String[] stringArray = this.getCommands(string3);
        ProcessHandler processHandler = this.bet.runCommandsInEnvironmentShell(stringArray, file, false);
        log.println("exit code of dmake: " + processHandler.getExitCode());
        String string5 = processHandler.getOutputText();
        string5 = processHandler.getErrorText();
        this.assure("module '" + string + "' failed", this.verifyOutput(processHandler.getOutputText()), true);
        log.println(utils.getDateTime() + " module '" + string + "': kill existing office...");
        try {
            officeProvider.closeExistingOffice(param, true);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            log.println("Office seems not to be running");
        }
    }

    private void addIfQaUnoApiFolderExist(File file, ArrayList arrayList) {
        if (this.doesQaUnoApiFolderExist(file)) {
            arrayList.add(file.getName());
        }
    }

    private boolean doesQaUnoApiFolderExist(File file) {
        FolderFilter folderFilter = new FolderFilter("qa");
        File[] fileArray = file.listFiles(folderFilter);
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                FolderFilter folderFilter2 = new FolderFilter("unoapi");
                File[] fileArray2 = file2.listFiles(folderFilter2);
                if (fileArray2 == null || fileArray2.length <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private String[] getAllModuleCommand() {
        String[] stringArray = this.getModulesFromSourceRoot();
        String[] stringArray2 = this.getCheckModuleCommand(stringArray);
        return stringArray2;
    }

    private String[] getCheckModuleCommand(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i].indexOf(".") != -1 ? "checkModule(" + stringArray[i].substring(0, stringArray[i].indexOf(".")) + ")" : "checkModule(" + stringArray[i] + ")";
        }
        return stringArray2;
    }

    private String[] getCommands(String string) {
        String[] stringArray = null;
        String string2 = (String)param.get("OperatingSystem");
        log.println("prepare command for platform " + string2);
        stringArray = string2.equals("wntmsci") ? new String[]{"cdd " + string, "dmake"} : new String[]{"cd " + string, "dmake"};
        return stringArray;
    }

    private String[] getCwsModuleCommand() {
        String string = (String)param.get("Version");
        String[] stringArray = null;
        if (string.startsWith("cws_")) {
            try {
                String string2 = string.substring(4, string.length());
                CwsDataExchangeImpl cwsDataExchangeImpl = new CwsDataExchangeImpl(string2, param, log);
                ArrayList arrayList = cwsDataExchangeImpl.getModules();
                ArrayList arrayList2 = new ArrayList();
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    File file = new File(this.mSRC_ROOT + File.separator + (String)iterator.next());
                    this.addIfQaUnoApiFolderExist(file, arrayList2);
                }
                stringArray = arrayList2.toArray(new String[0]);
            }
            catch (ParameterNotFoundException parameterNotFoundException) {
                this.failed(parameterNotFoundException.toString(), false);
            }
        } else {
            stringArray = this.getModulesFromSourceRoot();
        }
        String[] stringArray2 = this.getCheckModuleCommand(stringArray);
        return stringArray2;
    }

    private String[] getDefinedModuleCommand(String string) {
        String[] stringArray = null;
        if (string.indexOf(",") != -1) {
            String[] stringArray2 = string.split(",");
            stringArray = new String[stringArray2.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                String string2 = stringArray2[i].trim();
                File file = new File(this.mSRC_ROOT + File.separator + string2);
                if (!file.exists()) {
                    file = new File(this.mSRC_ROOT + File.separator + string2 + ".lnk");
                }
                if (!this.doesQaUnoApiFolderExist(file)) continue;
                stringArray[i] = "checkModule(" + string2 + ")";
            }
        } else {
            File file = new File(this.mSRC_ROOT + File.separator + string);
            if (!file.exists()) {
                file = new File(this.mSRC_ROOT + File.separator + string + ".lnk");
            }
            if (this.doesQaUnoApiFolderExist(file)) {
                stringArray = new String[]{"checkModule(" + string + ")"};
            }
        }
        return stringArray;
    }

    private String getModulePath(String string) {
        String string2 = null;
        String string3 = System.getProperty("file.separator");
        File file = new File(this.mSRC_ROOT);
        FolderFilter folderFilter = new FolderFilter(string);
        File[] fileArray = file.listFiles(folderFilter);
        if (fileArray != null) {
            if (this.mDebug) {
                log.println("moduleTree length:" + fileArray.length);
                log.println("moduleTree: " + fileArray[0].getAbsolutePath());
            }
            if (fileArray != null) {
                string2 = fileArray[0].getAbsolutePath() + string3 + "qa" + string3 + "unoapi";
            }
        }
        return string2;
    }

    private String getTranslatedNames(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("fwk", "framework");
        hashMap.put("fwl", "framework");
        hashMap.put("sch", "chart2");
        hashMap.put("sysmgr1", "configmgr");
        hashMap.put("cfgmag2", "configmgr");
        hashMap.put("lnn", "lingu");
        hashMap.put("lng", "linguistic");
        hashMap.put("sfx", "sfx2");
        hashMap.put("sm", "starmath");
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2;
            String string3 = (String)iterator.next();
            int n = (string = string.replaceAll(string3, string2 = (String)hashMap.get(string3))).split(string2).length;
            if (n <= 2) continue;
            for (int i = 2; i < n; ++i) {
                string.replaceFirst("," + string2, "");
            }
        }
        return string;
    }

    private boolean verifyOutput(String string) {
        log.println("verify output...");
        boolean bl = false;
        String[] stringArray = string.split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string2.matches("[0-9]+? of [0-9]+? tests failed")) continue;
            log.println("mached line: " + string2);
            if (string2.matches("0 of [0-9]+? tests failed")) {
                bl = true;
                log.println("Module passed OK");
                continue;
            }
            log.println("Module passed FAILED");
        }
        if (!bl) {
            log.println("ERROR: could not find '0 of [0-9]+? tests failed' in output");
        }
        return bl;
    }

    private String[] getModulesFromSourceRoot() {
        log.println("**** run module tests over all modules ****");
        log.println("search for qa/unoapi foldres in all modules based in ");
        log.println("'" + this.mSRC_ROOT + "'");
        ArrayList arrayList = new ArrayList();
        File file = new File(this.mSRC_ROOT);
        File[] fileArray = file.listFiles();
        this.assure("Could not find any files in SOURCE_ROOT=" + this.mSRC_ROOT, fileArray != null, false);
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            this.addIfQaUnoApiFolderExist(file2, arrayList);
        }
        String[] stringArray = arrayList.toArray(new String[0]);
        return stringArray;
    }

    public void module(String string) {
        String[] stringArray;
        ComplexDescGetter complexDescGetter = new ComplexDescGetter();
        DescEntry descEntry = null;
        if ((string = string.trim()).equals("all")) {
            stringArray = this.getAllModuleCommand();
        } else if (string.equals("auto")) {
            stringArray = this.getCwsModuleCommand();
        } else {
            string = this.getTranslatedNames(string);
            stringArray = this.getDefinedModuleCommand(string);
        }
        if (stringArray != null && stringArray.length > 0) {
            descEntry = complexDescGetter.createTestDesc("complex.unoapi.CheckModuleAPI", "complex.unoapi.CheckModuleAPI", stringArray, log);
            java_complex java_complex2 = new java_complex();
            log.println("********** start test *************");
            boolean bl = java_complex2.executeTest(param, new DescEntry[]{descEntry});
            log.println("********** end test *************");
            this.assure("CheckModuleAPI.module(" + string + ") PASSED.FAILED", bl);
        } else {
            log.println("No modules containing qa/unoapi foder found => OK");
            this.state = true;
        }
        this.setUnoApiCwsStatus(this.state);
    }

    private void setUnoApiCwsStatus(boolean bl) {
        String string;
        if (!param.getBool("NoCwsAttach") && (string = (String)param.get("Version")).startsWith("cws_")) {
            try {
                String string2 = string.substring(4, string.length());
                CwsDataExchangeImpl cwsDataExchangeImpl = new CwsDataExchangeImpl(string2, param, log);
                cwsDataExchangeImpl.setUnoApiCwsStatus(bl);
            }
            catch (ParameterNotFoundException parameterNotFoundException) {
                log.println("ERROR: could not wirte status to EIS database: " + parameterNotFoundException.toString());
            }
        }
    }

    public String[] getTestMethodNames() {
        return new String[]{"module(all)"};
    }

    class FolderFilter
    implements FileFilter {
        private String mFolderName;

        public FolderFilter(String string) {
            this.mFolderName = string;
        }

        public boolean accept(File file) {
            boolean bl = false;
            if (file.isDirectory()) {
                if (file.getName().equals(this.mFolderName)) {
                    bl = true;
                } else if (file.getName().equals(this.mFolderName + ".lnk")) {
                    bl = true;
                }
            }
            return bl;
        }
    }
}

