/*
 * Decompiled with CFR 0.152.
 */
package base;

import base.TestBase;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.XMultiServiceFactory;
import helper.APIDescGetter;
import helper.AppProvider;
import helper.ProcessHandler;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import lib.MultiMethodTest;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import lib.TestResult;
import share.DescEntry;
import share.DescGetter;
import share.LogWriter;
import stats.OutProducerFactory;
import stats.Summarizer;
import util.DynamicClassLoader;
import util.utils;

public class java_fat
implements TestBase {
    public static boolean debug = false;
    public static boolean keepdocument = false;
    public static boolean logging = true;
    public static boolean newOffice = false;
    private DynamicClassLoader dcl = null;

    public boolean executeTest(TestParameters testParameters) {
        ProcessHandler processHandler;
        int n;
        this.dcl = new DynamicClassLoader();
        APIDescGetter aPIDescGetter = new APIDescGetter();
        String string = (String)testParameters.get("TestJob");
        String string2 = (String)testParameters.get("ExclusionList");
        Vector vector = null;
        boolean bl = true;
        debug = testParameters.getBool("DebugIsActive");
        logging = testParameters.getBool("LoggingIsActive");
        keepdocument = testParameters.getBool("KeepDocument");
        newOffice = testParameters.getBool("NewOfficeInstance");
        if (keepdocument) {
            System.setProperty("KeepDocument", "true");
        }
        if (string2 != null) {
            vector = this.getExclusionList(string2, debug);
        }
        System.out.println("Getting Descriptions for Job: " + string);
        DescEntry[] descEntryArray = ((DescGetter)aPIDescGetter).getDescriptionFor(string, (String)testParameters.get("DescriptionPath"), debug);
        System.out.println();
        if (descEntryArray == null) {
            System.out.println("Couldn't get Description for Job: " + string);
            return false;
        }
        AppProvider appProvider = this.startOffice(testParameters);
        boolean bl2 = true;
        for (n = 0; n < descEntryArray.length; ++n) {
            LogWriter logWriter;
            LogWriter logWriter2;
            if (descEntryArray[n] == null) continue;
            if (descEntryArray[n].hasErrorMsg) {
                System.out.println(descEntryArray[n].ErrorMsg);
                continue;
            }
            if (!bl2 && newOffice) {
                if (!appProvider.closeExistingOffice(testParameters, true)) {
                    appProvider.disposeManager(testParameters);
                }
                this.startOffice(testParameters);
            }
            bl2 = false;
            XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
            if (xMultiServiceFactory == null) {
                bl = false;
                continue;
            }
            DescEntry descEntry = descEntryArray[n];
            Summarizer summarizer = new Summarizer();
            TestCase testCase = null;
            try {
                testCase = (TestCase)this.dcl.getInstance("mod._" + descEntry.entryName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                descEntry.ErrorMsg = illegalArgumentException.getMessage();
                descEntry.hasErrorMsg = true;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                descEntry.ErrorMsg = noClassDefFoundError.getMessage();
                descEntry.hasErrorMsg = true;
            }
            if (testCase == null) {
                Summarizer.summarizeDown(descEntry, descEntry.ErrorMsg);
                logWriter2 = OutProducerFactory.createOutProducer(testParameters);
                descEntry.UserDefinedParams = testParameters;
                logWriter2.initialize(descEntry, logging);
                logWriter2.summary(descEntry);
                continue;
            }
            if (debug) {
                System.out.println("sleeping 5 seconds..");
            }
            utils.shortWait(5000);
            System.out.println("Creating: " + descEntry.entryName);
            logWriter2 = (LogWriter)this.dcl.getInstance((String)testParameters.get("LogWriter"));
            logWriter2.initialize(descEntry, logging);
            descEntry.UserDefinedParams = testParameters;
            TestEnvironment testEnvironment = null;
            try {
                testCase.setLogWriter((PrintWriter)((Object)logWriter2));
                testCase.initializeTestCase(testParameters);
                testEnvironment = testCase.getTestEnvironment(testParameters);
            }
            catch (Exception exception) {
                System.out.println("Exception while creating " + testCase.getObjectName());
                System.out.println("Message " + exception.getMessage());
                exception.printStackTrace();
                testEnvironment = null;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                System.out.println("Exception while creating " + testCase.getObjectName());
                System.out.println("Message " + unsatisfiedLinkError.getMessage());
                testEnvironment = null;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                System.out.println("Exception while creating " + testCase.getObjectName());
                System.out.println("Message " + noClassDefFoundError.getMessage());
                testEnvironment = null;
            }
            if (testEnvironment == null) {
                Summarizer.summarizeDown(descEntry, "Couldn't create " + testCase.getObjectName());
                logWriter = OutProducerFactory.createOutProducer(testParameters);
                descEntry.UserDefinedParams = testParameters;
                logWriter.initialize(descEntry, logging);
                logWriter.summary(descEntry);
                continue;
            }
            System.out.println(testCase.getObjectName() + " recreated ");
            for (int i = 0; i < descEntry.SubEntryCount; ++i) {
                ProcessHandler processHandler2;
                if (!descEntry.SubEntries[i].isToTest) {
                    Summarizer.summarizeDown(descEntry.SubEntries[i], "not part of the job");
                    continue;
                }
                if (vector != null && vector.contains(descEntry.SubEntries[i].longName)) {
                    Summarizer.summarizeDown(descEntry.SubEntries[i], "known issue");
                    continue;
                }
                System.out.println("running: '" + descEntry.SubEntries[i].entryName + "'");
                LogWriter logWriter3 = (LogWriter)this.dcl.getInstance((String)testParameters.get("LogWriter"));
                logWriter3.initialize(descEntry.SubEntries[i], logging);
                descEntry.SubEntries[i].UserDefinedParams = testParameters;
                descEntry.SubEntries[i].Logger = logWriter3;
                if (testEnvironment == null || testEnvironment.isDisposed()) {
                    processHandler2 = (ProcessHandler)testParameters.get("AppProvider");
                    if (processHandler2 != null) {
                        appProvider.closeExistingOffice(testParameters, true);
                        this.shortWait(5000);
                    }
                    testEnvironment = this.getEnv(descEntry, testParameters);
                }
                processHandler2 = null;
                TestResult testResult = null;
                int n2 = 0;
                boolean bl3 = false;
                while (!bl3) {
                    try {
                        ++n2;
                        bl3 = true;
                        testResult = this.executeInterfaceTest(descEntry.SubEntries[i], testEnvironment, testParameters);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        System.out.println("Couldn't load class " + descEntry.SubEntries[i].entryName);
                        System.out.println("**** " + illegalArgumentException.getMessage() + " ****");
                        Summarizer.summarizeDown(descEntry.SubEntries[i], illegalArgumentException.getMessage());
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        System.out.println("Couldn't load class " + descEntry.SubEntries[i].entryName);
                        System.out.println("**** " + noClassDefFoundError.getMessage() + " ****");
                        Summarizer.summarizeDown(descEntry.SubEntries[i], noClassDefFoundError.getMessage());
                    }
                    catch (RuntimeException runtimeException) {
                        ProcessHandler processHandler3 = (ProcessHandler)testParameters.get("AppProvider");
                        if (processHandler3 != null) {
                            appProvider.closeExistingOffice(testParameters, true);
                            this.shortWait(5000);
                        }
                        testEnvironment = this.getEnv(descEntry, testParameters);
                        if (n2 < 2) {
                            bl3 = false;
                            continue;
                        }
                        Summarizer.summarizeDown(descEntry.SubEntries[i], runtimeException.toString() + ".FAILED");
                    }
                }
                if (testResult != null) {
                    for (int j = 0; j < descEntry.SubEntries[i].SubEntryCount; ++j) {
                        if (!testResult.hasMethod(descEntry.SubEntries[i].SubEntries[j].entryName)) continue;
                        descEntry.SubEntries[i].SubEntries[j].State = testResult.getStatusFor(descEntry.SubEntries[i].SubEntries[j].entryName).toString();
                    }
                }
                summarizer.summarizeUp(descEntry.SubEntries[i]);
                LogWriter logWriter4 = OutProducerFactory.createOutProducer(testParameters);
                descEntry.SubEntries[i].UserDefinedParams = testParameters;
                logWriter4.initialize(descEntry.SubEntries[i], logging);
                logWriter4.summary(descEntry.SubEntries[i]);
            }
            try {
                if (!keepdocument) {
                    testCase.cleanupTestCase(testParameters);
                }
            }
            catch (Exception exception) {
                System.out.println("couldn't cleanup");
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                System.out.println("couldn't cleanup");
            }
            summarizer.summarizeUp(descEntry);
            logWriter = OutProducerFactory.createOutProducer(testParameters);
            logWriter.initialize(descEntry, logging);
            logWriter.summary(descEntry);
        }
        if (descEntryArray.length > 1) {
            System.out.println();
            n = 0;
            System.out.println("Failures that appeared during scenario execution:");
            for (int i = 0; i < descEntryArray.length; ++i) {
                if (descEntryArray[i].State.endsWith("OK")) continue;
                System.out.println("\t " + descEntryArray[i].longName);
                ++n;
            }
            System.out.println(n + " of " + descEntryArray.length + " tests failed");
        }
        if ((processHandler = (ProcessHandler)testParameters.get("AppProvider")) != null) {
            appProvider.closeExistingOffice(testParameters, true);
            this.shortWait(5000);
        }
        return bl;
    }

    protected TestEnvironment getEnv(DescEntry descEntry, TestParameters testParameters) {
        AppProvider appProvider = this.startOffice(testParameters);
        TestCase testCase = null;
        try {
            testCase = (TestCase)this.dcl.getInstance("mod._" + descEntry.entryName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            descEntry.ErrorMsg = illegalArgumentException.getMessage();
            descEntry.hasErrorMsg = true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            descEntry.ErrorMsg = noClassDefFoundError.getMessage();
            descEntry.hasErrorMsg = true;
        }
        System.out.println("Creating: " + descEntry.entryName);
        descEntry.UserDefinedParams = testParameters;
        LogWriter logWriter = (LogWriter)this.dcl.getInstance((String)testParameters.get("LogWriter"));
        logWriter.initialize(descEntry, logging);
        testCase.setLogWriter((PrintWriter)((Object)logWriter));
        TestEnvironment testEnvironment = null;
        try {
            testCase.initializeTestCase(testParameters);
            testEnvironment = testCase.getTestEnvironment(testParameters);
        }
        catch (DisposedException disposedException) {
            System.out.println("Office disposed");
            ProcessHandler processHandler = (ProcessHandler)testParameters.get("AppProvider");
            if (processHandler != null) {
                appProvider.closeExistingOffice(testParameters, true);
                this.shortWait(5000);
            }
        }
        catch (StatusException statusException) {
            System.out.println(statusException.getMessage());
            ProcessHandler processHandler = (ProcessHandler)testParameters.get("AppProvider");
            if (processHandler != null) {
                appProvider.closeExistingOffice(testParameters, true);
                this.shortWait(5000);
            }
            descEntry.ErrorMsg = statusException.getMessage();
            descEntry.hasErrorMsg = true;
        }
        return testEnvironment;
    }

    protected void shortWait(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected Vector getExclusionList(String string, boolean bl) {
        Vector<String> vector = new Vector<String>();
        String string2 = "#";
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (bl) {
                System.out.println("Couldn't find file " + string);
            }
            return vector;
        }
        while (string2 != null) {
            try {
                if (!string2.startsWith("#") && string2.length() > 1) {
                    vector.add(string2.trim());
                }
                string2 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                if (bl) {
                    System.out.println("Exception while reading exclusion list");
                }
                return vector;
            }
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            if (bl) {
                System.out.println("Couldn't close file " + string);
            }
            return vector;
        }
        return vector;
    }

    private TestResult executeInterfaceTest(DescEntry descEntry, TestEnvironment testEnvironment, TestParameters testParameters) throws IllegalArgumentException, NoClassDefFoundError {
        MultiMethodTest multiMethodTest = (MultiMethodTest)this.dcl.getInstance(descEntry.entryName);
        return multiMethodTest.run(descEntry, testEnvironment, testParameters);
    }

    private AppProvider startOffice(TestParameters testParameters) {
        String string;
        AppProvider appProvider;
        if (this.dcl == null) {
            this.dcl = new DynamicClassLoader();
        }
        if ((appProvider = (AppProvider)this.dcl.getInstance(string = (String)testParameters.get("OfficeProvider"))) == null) {
            System.out.println("ERROR: Wrong parameter 'OfficeProvider',  it cannot be instantiated.");
            System.exit(-1);
        }
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)appProvider.getManager(testParameters);
        testParameters.put("ServiceFactory", xMultiServiceFactory);
        return appProvider;
    }
}

