/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xmlns.writer;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.jfree.io.IOUtils;
import org.jfree.xmlns.common.AttributeList;
import org.jfree.xmlns.writer.DefaultTagDescription;
import org.jfree.xmlns.writer.TagDescription;
import org.jfree.xmlns.writer.XmlWriterSupport;

public class XmlWriter
extends XmlWriterSupport {
    private Writer writer;

    public XmlWriter(Writer writer) {
        this(writer, "  ");
    }

    public XmlWriter(Writer writer, TagDescription tagDescription) {
        this(writer, tagDescription, "  ");
    }

    public XmlWriter(Writer writer, String indentString) {
        this(writer, new DefaultTagDescription(), indentString);
    }

    public XmlWriter(Writer writer, TagDescription tagDescription, String indentString) {
        super(tagDescription, indentString);
        if (writer == null) {
            throw new NullPointerException("Writer must not be null.");
        }
        this.writer = writer;
    }

    public void writeXmlDeclaration(String encoding) throws IOException {
        if (encoding == null) {
            this.writer.write("<?xml version=\"1.0\"");
            this.writer.write("\"?>");
            this.writer.write(this.getLineSeparator());
            return;
        }
        this.writer.write("<?xml version=\"1.0\" encoding=\"");
        this.writer.write(encoding);
        this.writer.write("\"?>");
        this.writer.write(this.getLineSeparator());
    }

    public void writeTag(String namespace, String name, boolean close) throws IOException {
        if (close) {
            this.writeTag(this.writer, namespace, name, null, true);
        } else {
            this.writeTag(this.writer, namespace, name, null, false);
        }
    }

    public void writeCloseTag() throws IOException {
        super.writeCloseTag(this.writer);
    }

    public void writeTag(String namespace, String name, String attributeName, String attributeValue, boolean close) throws IOException {
        this.writeTag(this.writer, namespace, name, attributeName, attributeValue, close);
    }

    public void writeTag(String namespace, String name, AttributeList attributes, boolean close) throws IOException {
        this.writeTag(this.writer, namespace, name, attributes, close);
    }

    public void writeText(String text) throws IOException {
        this.writer.write(text);
        this.setLineEmpty(false);
    }

    public void writeStream(Reader reader) throws IOException {
        IOUtils.getInstance().copyWriter(reader, this.writer);
        this.setLineEmpty(false);
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void writeComment(String comment) throws IOException {
        super.writeComment(this.writer, comment);
    }

    public void writeNewLine() throws IOException {
        super.writeNewLine(this.writer);
    }

    public void flush() throws IOException {
        this.writer.flush();
    }
}

