/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xmlns.writer;

import java.util.HashMap;
import java.util.Iterator;
import org.jfree.util.Configuration;
import org.jfree.xmlns.writer.TagDescription;

public class DefaultTagDescription
implements TagDescription {
    private HashMap defaultDefinitions = new HashMap();
    private HashMap tagData = new HashMap();
    private String defaultNamespace;

    public void configure(Configuration conf, String prefix) {
        HashMap<String, String> knownNamespaces = new HashMap<String, String>();
        String nsConfPrefix = prefix + "namespace.";
        Iterator namespaces = conf.findPropertyKeys(nsConfPrefix);
        while (namespaces.hasNext()) {
            String key = (String)namespaces.next();
            String nsPrefix = key.substring(nsConfPrefix.length());
            String nsUri = conf.getConfigProperty(key);
            knownNamespaces.put(nsPrefix, nsUri);
        }
        this.defaultNamespace = (String)knownNamespaces.get(conf.getConfigProperty(prefix + "namespace"));
        String globalDefaultKey = prefix + "default";
        boolean globalValue = "deny".equals(conf.getConfigProperty(globalDefaultKey));
        this.defaultDefinitions.put(null, globalValue ? Boolean.TRUE : Boolean.FALSE);
        String nsDefaultPrefix = prefix + "default.";
        Iterator defaults = conf.findPropertyKeys(nsDefaultPrefix);
        while (defaults.hasNext()) {
            String key = (String)defaults.next();
            String nsPrefix = key.substring(nsDefaultPrefix.length());
            String nsUri = (String)knownNamespaces.get(nsPrefix);
            if (nsUri == null) continue;
            boolean value = "deny".equals(conf.getConfigProperty(key));
            this.defaultDefinitions.put(nsUri, value ? Boolean.TRUE : Boolean.FALSE);
        }
        String nsTagsPrefix = prefix + "tag.";
        Iterator tags = conf.findPropertyKeys(nsTagsPrefix);
        while (tags.hasNext()) {
            String key = (String)tags.next();
            String tagDef = key.substring(nsTagsPrefix.length());
            boolean value = "deny".equals(conf.getConfigProperty(key));
            int delim = tagDef.indexOf(46);
            if (delim == -1) {
                this.tagData.put(new TagDefinitionKey(null, tagDef), value ? Boolean.TRUE : Boolean.FALSE);
                continue;
            }
            String nsPrefix = tagDef.substring(0, delim);
            String nsUri = (String)knownNamespaces.get(nsPrefix);
            if (nsUri == null) continue;
            String tagName = tagDef.substring(delim + 1);
            this.tagData.put(new TagDefinitionKey(nsUri, tagName), value ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean hasCData(String namespace, String tagname) {
        TagDefinitionKey key;
        Object tagVal;
        if (namespace == null) {
            namespace = this.defaultNamespace;
        }
        if ((tagVal = this.tagData.get(key = new TagDefinitionKey(namespace, tagname))) != null) {
            return Boolean.TRUE.equals(tagVal);
        }
        Object obj = this.defaultDefinitions.get(namespace);
        if (obj != null) {
            return Boolean.TRUE.equals(obj);
        }
        return Boolean.TRUE.equals(this.defaultDefinitions.get(null));
    }

    private static class TagDefinitionKey {
        private String namespace;
        private String tagName;

        private TagDefinitionKey(String namespace, String tagName) {
            this.namespace = namespace;
            this.tagName = tagName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TagDefinitionKey that = (TagDefinitionKey)o;
            if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
                return false;
            }
            return !(this.tagName != null ? !this.tagName.equals(that.tagName) : that.tagName != null);
        }

        public int hashCode() {
            int result = this.namespace != null ? this.namespace.hashCode() : 0;
            result = 29 * result + (this.tagName != null ? this.tagName.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "TagDefinitionKey{namespace='" + this.namespace + '\'' + ", tagName='" + this.tagName + '\'' + '}';
        }
    }
}

