/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xmlns.writer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class CharacterEntityParser {
    private final HashMap entities;
    private final HashMap reverse;

    public CharacterEntityParser(Properties characterEntities) {
        this.entities = new HashMap<Object, Object>(characterEntities);
        this.reverse = new HashMap();
        Iterator entries = this.entities.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            this.reverse.put(entry.getValue(), entry.getKey());
        }
    }

    public CharacterEntityParser(HashMap characterEntities) {
        this.entities = (HashMap)characterEntities.clone();
        this.reverse = new HashMap();
        Iterator entries = this.entities.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            String key = (String)entry.getValue();
            String value = (String)entry.getKey();
            this.reverse.put(key, value);
        }
    }

    public static CharacterEntityParser createXMLEntityParser() {
        HashMap<String, String> entities = new HashMap<String, String>();
        entities.put("amp", "&");
        entities.put("quot", "\"");
        entities.put("lt", "<");
        entities.put("gt", ">");
        entities.put("apos", "'");
        return new CharacterEntityParser(entities);
    }

    private HashMap getEntities() {
        return this.entities;
    }

    private HashMap getReverse() {
        return this.reverse;
    }

    private String lookupCharacter(String key) {
        return (String)this.getEntities().get(key);
    }

    private String lookupEntity(String character) {
        String val = (String)this.getReverse().get(character);
        if (val == null) {
            return null;
        }
        return '&' + val + ';';
    }

    public String encodeEntities(String value) {
        int length = value.length();
        StringBuffer writer = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            String character = String.valueOf(value.charAt(i));
            String lookup = this.lookupEntity(character);
            if (lookup == null) {
                writer.append(character);
                continue;
            }
            writer.append(lookup);
        }
        return writer.toString();
    }

    public String decodeEntities(String value) {
        int parserIndex = 0;
        int subStart = value.indexOf(38, parserIndex);
        if (subStart == -1) {
            return value;
        }
        int subEnd = value.indexOf(59, subStart);
        if (subEnd == -1) {
            return value;
        }
        StringBuffer bufValue = new StringBuffer(value.substring(0, subStart));
        do {
            if (value.charAt(subStart + 1) == '#') {
                int subValue = this.parseInt(value.substring(subStart + 2, subEnd), 0);
                if (subValue >= 1 && subValue <= 65536) {
                    char[] chr = new char[]{(char)subValue};
                    bufValue.append(chr);
                } else {
                    bufValue.append(value.substring(subStart, subEnd));
                }
            } else {
                String entity = value.substring(subStart + 1, subEnd);
                String replaceString = this.lookupCharacter(entity);
                if (replaceString != null) {
                    bufValue.append(this.decodeEntities(replaceString));
                } else {
                    bufValue.append('&');
                    bufValue.append(entity);
                    bufValue.append(';');
                }
            }
            parserIndex = subEnd + 1;
            subStart = value.indexOf(38, parserIndex);
            if (subStart == -1) {
                bufValue.append(value.substring(parserIndex));
                subEnd = -1;
                continue;
            }
            subEnd = value.indexOf(59, subStart);
            if (subEnd == -1) {
                bufValue.append(value.substring(parserIndex));
                continue;
            }
            bufValue.append(value.substring(parserIndex, subStart));
        } while (subStart != -1 && subEnd != -1);
        return bufValue.toString();
    }

    private int parseInt(String s, int defaultVal) {
        if (s == null) {
            return defaultVal;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Exception exception) {
            return defaultVal;
        }
    }
}

