/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xmlns.parser;

import java.io.InputStream;
import java.net.URL;
import org.jfree.resourceloader.ResourceData;
import org.jfree.resourceloader.ResourceLoadingException;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.util.Log;
import org.xml.sax.InputSource;

public class ResourceDataInputSource
extends InputSource {
    private ResourceData data;
    private long version;
    private ResourceManager caller;

    public ResourceDataInputSource(ResourceData data, ResourceManager caller) throws ResourceLoadingException {
        if (data == null) {
            throw new NullPointerException("Data must not be null");
        }
        if (caller == null) {
            throw new NullPointerException("ResourceManager must not be null");
        }
        this.data = data;
        this.version = data.getVersion(caller);
        this.caller = caller;
        URL url = caller.toURL(data.getKey());
        if (url != null) {
            this.setSystemId(url.toExternalForm());
        }
    }

    public void setByteStream(InputStream byteStream) {
        throw new UnsupportedOperationException();
    }

    public InputStream getByteStream() {
        try {
            return this.data.getResourceAsStream(this.caller);
        }
        catch (ResourceLoadingException e) {
            Log.error((Object)("Unable to create byte-stream: " + this.data.getKey()));
            return null;
        }
    }

    public ResourceData getData() {
        return this.data;
    }

    public long getVersion() {
        return this.version;
    }
}

