/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xmlns.parser;

import java.util.ArrayList;
import java.util.Properties;
import org.jfree.xmlns.parser.AbstractXmlReadHandler;
import org.jfree.xmlns.parser.PropertyReadHandler;
import org.jfree.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PropertiesReadHandler
extends AbstractXmlReadHandler {
    private ArrayList propertyHandlers;
    private String propertyTagName;
    private Properties result;

    public PropertiesReadHandler() {
        this("property");
    }

    public PropertiesReadHandler(String propertyTagName) {
        if (propertyTagName == null) {
            throw new NullPointerException();
        }
        this.propertyHandlers = new ArrayList();
        this.propertyTagName = propertyTagName;
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if (tagName.equals(this.propertyTagName)) {
            PropertyReadHandler prh = new PropertyReadHandler();
            this.propertyHandlers.add(prh);
            return prh;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        this.result = new Properties();
        for (int i = 0; i < this.propertyHandlers.size(); ++i) {
            PropertyReadHandler handler = (PropertyReadHandler)this.propertyHandlers.get(i);
            this.result.setProperty(handler.getName(), handler.getResult());
        }
    }

    public Properties getResult() {
        return this.result;
    }

    public Object getObject() throws SAXException {
        return this.result;
    }
}

