/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xmlns.parser;

import java.io.IOException;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.xmlns.parser.DefaultXmlDocumentInfo;
import org.jfree.xmlns.parser.FixNamespaceUriAttributes;
import org.jfree.xmlns.parser.ParserEntityResolver;
import org.jfree.xmlns.parser.RootXmlReadHandler;
import org.jfree.xmlns.parser.XmlFactoryModule;
import org.jfree.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MultiplexRootElementHandler
extends RootXmlReadHandler {
    private XmlFactoryModule[] rootHandlers;
    private RootEntityResolver entityResolver = new RootEntityResolver();
    private boolean xmlnsUrisNotAvailable;

    public MultiplexRootElementHandler(ResourceManager manager, ResourceKey source, ResourceKey context, long version, XmlFactoryModule[] rootHandlers) {
        super(manager, source, context, version);
        this.rootHandlers = (XmlFactoryModule[])rootHandlers.clone();
    }

    public boolean isXmlnsUrisNotAvailable() {
        return this.xmlnsUrisNotAvailable;
    }

    public void setXmlnsUrisNotAvailable(boolean xmlnsUrisNotAvailable) {
        this.xmlnsUrisNotAvailable = xmlnsUrisNotAvailable;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public ParserEntityResolver getParserEntityResolver() {
        return this.entityResolver.getEntityResolver();
    }

    protected XmlFactoryModule[] getRootHandlers() {
        return this.rootHandlers;
    }

    protected void interceptFirstStartElement(String originalUri, String localName, String qName, Attributes attributes) throws SAXException {
        DefaultXmlDocumentInfo documentInfo = new DefaultXmlDocumentInfo();
        documentInfo.setPublicDTDId(this.entityResolver.getPublicId());
        documentInfo.setSystemDTDId(this.entityResolver.getSystemId());
        documentInfo.setRootElement(localName);
        documentInfo.setRootElementNameSpace(originalUri);
        String nsuri = attributes.getValue("xmlns");
        if (nsuri != null) {
            documentInfo.setDefaultNameSpace(nsuri);
        } else {
            documentInfo.setDefaultNameSpace("");
        }
        XmlFactoryModule bestRootHandler = null;
        int bestRootHandlerWeight = -1;
        for (int i = 0; i < this.rootHandlers.length; ++i) {
            XmlFactoryModule rootHandler = this.rootHandlers[i];
            int weight = rootHandler.getDocumentSupport(documentInfo);
            if (weight <= bestRootHandlerWeight) continue;
            bestRootHandler = rootHandler;
            bestRootHandlerWeight = weight;
        }
        if (bestRootHandlerWeight < 0 || bestRootHandler == null) {
            throw new SAXException("No suitable root handler known for this document: " + documentInfo);
        }
        XmlReadHandler readHandler = bestRootHandler.createReadHandler(documentInfo);
        if (readHandler == null) {
            throw new SAXException("Unable to create the root handler." + bestRootHandler);
        }
        String defaultNamespace = documentInfo.getDefaultNameSpace();
        if ((defaultNamespace == null || "".equals(defaultNamespace)) && (defaultNamespace = bestRootHandler.getDefaultNamespace(documentInfo)) != null && !"".equals(defaultNamespace)) {
            documentInfo.setRootElementNameSpace(defaultNamespace);
        }
        this.pushDefaultNamespace(defaultNamespace);
        String uri = (originalUri == null || "".equals(originalUri)) && defaultNamespace != null ? defaultNamespace : originalUri;
        attributes = new FixNamespaceUriAttributes(uri, attributes);
        this.installRootHandler(readHandler, uri, localName, attributes);
    }

    public Object getObject() {
        return null;
    }

    private static class RootEntityResolver
    implements EntityResolver {
        private ParserEntityResolver entityResolver = ParserEntityResolver.getDefaultResolver();
        private String publicId;
        private String systemId;

        private RootEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            this.publicId = publicId;
            this.systemId = systemId;
            return this.entityResolver.resolveEntity(publicId, systemId);
        }

        public String getPublicId() {
            return this.publicId;
        }

        public String getSystemId() {
            return this.systemId;
        }

        public ParserEntityResolver getEntityResolver() {
            return this.entityResolver;
        }
    }
}

