/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xmlns.parser;

import org.jfree.util.Log;
import org.jfree.util.LogContext;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class LoggingErrorHandler
implements ErrorHandler {
    private LogContext logContext = Log.createContext((Class)LoggingErrorHandler.class);

    public void warning(SAXParseException exception) throws SAXException {
        if (this.logContext.isDebugEnabled()) {
            if (exception.getMessage().startsWith("URI was not reported to parser for entity")) {
                return;
            }
            this.logContext.debug((Object)"Parser-Warning", (Exception)exception);
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        if (this.logContext.isWarningEnabled()) {
            if (this.logContext.isDebugEnabled()) {
                this.logContext.warn((Object)"Recoverable Parser-Error", (Exception)exception);
            } else {
                this.logContext.warn((Object)("Recoverable Parser-Error:" + exception.getMessage()));
            }
        }
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        if (this.logContext.isErrorEnabled()) {
            if (this.logContext.isDebugEnabled()) {
                this.logContext.error((Object)"Fatal Parser-Error", (Exception)exception);
            } else {
                this.logContext.error((Object)("Fatal Parser-Error:" + exception.getMessage()));
            }
        }
    }
}

