/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xmlns.parser;

import org.xml.sax.Attributes;

public class FixNamespaceUriAttributes
implements Attributes {
    private Attributes attributes;
    private String defaultNSUri;

    public FixNamespaceUriAttributes(String defaultNSUri, Attributes attributes) {
        this.attributes = attributes;
        this.defaultNSUri = defaultNSUri;
    }

    public int getLength() {
        return this.attributes.getLength();
    }

    public String getURI(int index) {
        String uri = this.attributes.getURI(index);
        if (uri == null || "".equals(uri)) {
            return this.defaultNSUri;
        }
        return uri;
    }

    public String getLocalName(int index) {
        String name = this.attributes.getLocalName(index);
        if (name == null || "".equals(name)) {
            return this.attributes.getQName(index);
        }
        return name;
    }

    public String getQName(int index) {
        return this.attributes.getQName(index);
    }

    public String getType(int index) {
        return this.attributes.getType(index);
    }

    public String getValue(int index) {
        return this.attributes.getValue(index);
    }

    public int getIndex(String uri, String localName) {
        int idx = this.attributes.getIndex(uri, localName);
        if (idx >= 0) {
            return idx;
        }
        if (this.defaultNSUri.equals(uri)) {
            return this.attributes.getIndex("", localName);
        }
        return -1;
    }

    public int getIndex(String qName) {
        return this.attributes.getIndex(qName);
    }

    public String getType(String uri, String localName) {
        String type = this.attributes.getType(uri, localName);
        if (type != null) {
            return type;
        }
        if (this.defaultNSUri.equals(uri)) {
            return this.attributes.getType("", localName);
        }
        return null;
    }

    public String getType(String qName) {
        return this.attributes.getType(qName);
    }

    public String getValue(String uri, String localName) {
        String value = this.attributes.getValue(uri, localName);
        if (value != null) {
            return value;
        }
        if (this.defaultNSUri.equals(uri)) {
            return this.attributes.getValue("", localName);
        }
        return null;
    }

    public String getValue(String qName) {
        return this.attributes.getValue(qName);
    }
}

