/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xmlns.parser;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jfree.resourceloader.CompoundResource;
import org.jfree.resourceloader.FactoryParameterKey;
import org.jfree.resourceloader.Resource;
import org.jfree.resourceloader.ResourceCreationException;
import org.jfree.resourceloader.ResourceData;
import org.jfree.resourceloader.ResourceFactory;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceKeyCreationException;
import org.jfree.resourceloader.ResourceLoadingException;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.resourceloader.loader.raw.RawResourceData;
import org.jfree.util.Configuration;
import org.jfree.util.DefaultConfiguration;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;
import org.jfree.xmlns.parser.LoggingErrorHandler;
import org.jfree.xmlns.parser.MultiplexRootElementHandler;
import org.jfree.xmlns.parser.ResourceDataInputSource;
import org.jfree.xmlns.parser.XmlFactoryModule;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class AbstractXmlResourceFactory
implements ResourceFactory {
    public static final String CONTENTBASE_KEY = "content-base";
    private HashSet modules = new HashSet();
    private SAXParserFactory factory;
    private static final byte[] EMPTY_DATA = new byte[0];
    static /* synthetic */ Class class$org$jfree$xmlns$parser$AbstractXmlResourceFactory;
    static /* synthetic */ Class class$org$jfree$xmlns$parser$XmlFactoryModule;

    protected AbstractXmlResourceFactory() {
    }

    protected SAXParser getParser() throws ParserConfigurationException, SAXException {
        if (this.factory == null) {
            this.factory = SAXParserFactory.newInstance();
        }
        return this.factory.newSAXParser();
    }

    protected void configureReader(XMLReader reader, MultiplexRootElementHandler handler) {
        try {
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler.getCommentHandler());
        }
        catch (SAXException se) {
            Log.debug((Object)"Comments are not supported by this SAX implementation.");
        }
        try {
            reader.setFeature("http://xml.org/sax/features/xmlns-uris", true);
        }
        catch (SAXException e) {
            handler.setXmlnsUrisNotAvailable(true);
        }
        try {
            reader.setFeature("http://xml.org/sax/features/namespaces", true);
            reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (SAXException e) {
            Log.warn((Object)"No Namespace features will be available. (Yes, this is serious)");
        }
    }

    public Resource create(ResourceManager manager, ResourceData data, ResourceKey context) throws ResourceCreationException, ResourceLoadingException {
        try {
            long version;
            ResourceKey contextKey;
            SAXParser parser = this.getParser();
            XMLReader reader = parser.getXMLReader();
            XmlFactoryModule[] rootHandlers = this.getModules();
            ResourceDataInputSource input = new ResourceDataInputSource(data, manager);
            ResourceKey targetKey = data.getKey();
            if (context == null) {
                contextKey = targetKey;
                version = data.getVersion(manager);
            } else {
                contextKey = context;
                version = -1L;
            }
            MultiplexRootElementHandler handler = new MultiplexRootElementHandler(manager, targetKey, contextKey, version, rootHandlers);
            DefaultConfiguration parserConfiguration = handler.getParserConfiguration();
            URL value = manager.toURL(contextKey);
            if (value != null) {
                parserConfiguration.setConfigProperty(CONTENTBASE_KEY, value.toExternalForm());
            }
            this.configureReader(reader, handler);
            reader.setContentHandler(handler);
            reader.setDTDHandler(handler);
            reader.setEntityResolver(handler.getEntityResolver());
            reader.setErrorHandler(this.getErrorHandler());
            Map parameters = targetKey.getFactoryParameters();
            Iterator it = parameters.keySet().iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof FactoryParameterKey)) continue;
                FactoryParameterKey fpk = (FactoryParameterKey)o;
                handler.setHelperObject(fpk.getName(), parameters.get(fpk));
            }
            reader.parse(input);
            Object createdProduct = this.finishResult(handler.getResult(), manager, data, contextKey);
            handler.getDependencyCollector().add(targetKey, data.getVersion(manager));
            return this.createResource(targetKey, handler, createdProduct);
        }
        catch (ParserConfigurationException e) {
            throw new ResourceCreationException("Unable to initialize the XML-Parser", (Exception)e);
        }
        catch (SAXException e) {
            throw new ResourceCreationException("Unable to parse the document", (Exception)e);
        }
        catch (IOException e) {
            throw new ResourceLoadingException("Unable to read the stream", (Exception)e);
        }
    }

    public Object parseDirectly(ResourceManager manager, InputSource input, ResourceKey context, Map parameters) throws ResourceKeyCreationException, ResourceCreationException, ResourceLoadingException {
        try {
            SAXParser parser = this.getParser();
            XMLReader reader = parser.getXMLReader();
            XmlFactoryModule[] rootHandlers = this.getModules();
            ResourceKey targetKey = manager.createKey((Object)EMPTY_DATA);
            ResourceKey contextKey = context == null ? targetKey : context;
            MultiplexRootElementHandler handler = new MultiplexRootElementHandler(manager, targetKey, contextKey, -1L, rootHandlers);
            this.configureReader(reader, handler);
            reader.setContentHandler(handler);
            reader.setDTDHandler(handler);
            reader.setEntityResolver(handler.getEntityResolver());
            reader.setErrorHandler(this.getErrorHandler());
            Iterator it = parameters.keySet().iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof FactoryParameterKey)) continue;
                FactoryParameterKey fpk = (FactoryParameterKey)o;
                handler.setHelperObject(fpk.getName(), parameters.get(fpk));
            }
            reader.parse(input);
            return this.finishResult(handler.getResult(), manager, (ResourceData)new RawResourceData(targetKey), contextKey);
        }
        catch (ParserConfigurationException e) {
            throw new ResourceCreationException("Unable to initialize the XML-Parser", (Exception)e);
        }
        catch (SAXException e) {
            throw new ResourceCreationException("Unable to parse the document", (Exception)e);
        }
        catch (IOException e) {
            throw new ResourceLoadingException("Unable to read the stream", (Exception)e);
        }
    }

    private XmlFactoryModule[] getModules() {
        return this.modules.toArray(new XmlFactoryModule[this.modules.size()]);
    }

    protected Resource createResource(ResourceKey targetKey, MultiplexRootElementHandler handler, Object createdProduct) {
        return new CompoundResource(targetKey, handler.getDependencyCollector(), createdProduct);
    }

    protected Object finishResult(Object res, ResourceManager manager, ResourceData data, ResourceKey context) throws ResourceCreationException, ResourceLoadingException {
        return res;
    }

    protected abstract Configuration getConfiguration();

    public void initializeDefaults() {
        String type = this.getFactoryType().getName();
        String prefix = "org.jfree.resourceloader.factory.modules." + type;
        Configuration config = this.getConfiguration();
        Iterator itType = config.findPropertyKeys(prefix);
        while (itType.hasNext()) {
            String key = (String)itType.next();
            String modClass = config.getConfigProperty(key);
            Object maybeFactory = ObjectUtilities.loadAndInstantiate((String)modClass, (Class)(class$org$jfree$xmlns$parser$AbstractXmlResourceFactory == null ? AbstractXmlResourceFactory.class$("org.jfree.xmlns.parser.AbstractXmlResourceFactory") : class$org$jfree$xmlns$parser$AbstractXmlResourceFactory), (Class)(class$org$jfree$xmlns$parser$XmlFactoryModule == null ? AbstractXmlResourceFactory.class$("org.jfree.xmlns.parser.XmlFactoryModule") : class$org$jfree$xmlns$parser$XmlFactoryModule));
            if (!(maybeFactory instanceof XmlFactoryModule)) continue;
            this.registerModule((XmlFactoryModule)maybeFactory);
        }
    }

    public void registerModule(XmlFactoryModule factoryModule) {
        if (factoryModule == null) {
            throw new NullPointerException();
        }
        this.modules.add(factoryModule);
    }

    protected ErrorHandler getErrorHandler() {
        return new LoggingErrorHandler();
    }
}

