/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xmlns.parser;

import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;
import org.jfree.xmlns.parser.IgnoreAnyChildReadHandler;
import org.jfree.xmlns.parser.RootXmlReadHandler;
import org.jfree.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class AbstractXmlReadHandler
implements XmlReadHandler {
    private RootXmlReadHandler rootHandler;
    private String tagName;
    private String uri;
    private boolean firstCall = true;

    public void init(RootXmlReadHandler rootHandler, String uri, String tagName) {
        if (rootHandler == null) {
            throw new NullPointerException("Root handler must not be null");
        }
        if (tagName == null) {
            throw new NullPointerException("Tag name must not be null");
        }
        this.uri = uri;
        this.rootHandler = rootHandler;
        this.tagName = tagName;
    }

    public final void startElement(String uri, String tagName, Attributes attrs) throws SAXException {
        if (this.firstCall) {
            if (!this.tagName.equals(tagName) || !this.uri.equals(uri)) {
                throw new SAXException("Expected <" + this.tagName + ">, found <" + tagName + '>');
            }
            this.firstCall = false;
            this.startParsing(attrs);
        } else {
            XmlReadHandler childHandler = this.getHandlerForChild(uri, tagName, attrs);
            if (childHandler == null) {
                Log.warn((Object)("Unknown tag <" + uri + ':' + tagName + ">: Start to ignore this element and all of its childs."));
                IgnoreAnyChildReadHandler ignoreAnyChildReadHandler = new IgnoreAnyChildReadHandler();
                ignoreAnyChildReadHandler.init(this.getRootHandler(), uri, tagName);
                this.rootHandler.recurse(ignoreAnyChildReadHandler, uri, tagName, attrs);
            } else {
                childHandler.init(this.getRootHandler(), uri, tagName);
                this.rootHandler.recurse(childHandler, uri, tagName, attrs);
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    public final void endElement(String uri, String tagName) throws SAXException {
        if (!this.tagName.equals(tagName) || !this.uri.equals(uri)) {
            throw new SAXException("Illegal Parser State.");
        }
        this.doneParsing();
        this.rootHandler.unwind(uri, tagName);
    }

    protected void startParsing(Attributes attrs) throws SAXException {
    }

    protected void doneParsing() throws SAXException {
    }

    protected boolean isSameNamespace(String url) {
        return ObjectUtilities.equal((Object)url, (Object)this.getUri());
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        return null;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getUri() {
        return this.uri;
    }

    public RootXmlReadHandler getRootHandler() {
        return this.rootHandler;
    }

    public Locator getLocator() {
        return this.rootHandler.getDocumentLocator();
    }
}

