/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.accessibility.XAccessibleSelection;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import org.openoffice.java.accessibility.AccessibleObjectFactory;
import org.openoffice.java.accessibility.Container;
import org.openoffice.java.accessibility.MenuItem;

public class MenuContainer
extends Container
implements Accessible {
    protected XAccessibleSelection unoAccessibleSelection = null;

    protected MenuContainer(AccessibleRole accessibleRole, XAccessible xAccessible, XAccessibleContext xAccessibleContext) {
        super(accessibleRole, xAccessible, xAccessibleContext);
    }

    protected XAccessibleEventListener createEventListener() {
        return new AccessibleMenuContainerListener();
    }

    public AccessibleContext createAccessibleContext() {
        return new AccessibleMenuContainer();
    }

    protected class AccessibleMenuContainer
    extends Container.AccessibleContainer
    implements AccessibleSelection {
        protected AccessibleMenuContainer() {
            MenuContainer.this.unoAccessibleSelection = (XAccessibleSelection)UnoRuntime.queryInterface(XAccessibleSelection.class, (Object)MenuContainer.this.unoAccessibleContext);
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public Accessible getAccessibleSelection(int n) {
            try {
                return (Accessible)((Object)AccessibleObjectFactory.getAccessibleComponent(MenuContainer.this.unoAccessibleSelection.getSelectedAccessibleChild(n)));
            }
            catch (com.sun.star.uno.Exception exception) {
                return null;
            }
        }

        public void addAccessibleSelection(int n) {
            try {
                Accessible accessible = this.getAccessibleChild(n);
                if (accessible instanceof MenuItem) {
                    accessible.getAccessibleContext().getAccessibleAction().doAccessibleAction(0);
                } else {
                    MenuContainer.this.unoAccessibleSelection.selectAccessibleChild(n);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void clearAccessibleSelection() {
            try {
                MenuContainer.this.unoAccessibleSelection.clearAccessibleSelection();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        public int getAccessibleSelectionCount() {
            try {
                return MenuContainer.this.unoAccessibleSelection.getSelectedAccessibleChildCount();
            }
            catch (RuntimeException runtimeException) {
                return 0;
            }
        }

        public boolean isAccessibleChildSelected(int n) {
            try {
                return MenuContainer.this.unoAccessibleSelection.isAccessibleChildSelected(n);
            }
            catch (Exception exception) {
                return false;
            }
        }

        public void removeAccessibleSelection(int n) {
            if (this.isAccessibleChildSelected(n)) {
                this.clearAccessibleSelection();
            }
        }

        public void selectAllAccessibleSelection() {
        }
    }

    protected class AccessibleMenuContainerListener
    extends Container.AccessibleContainerListener {
        protected AccessibleMenuContainerListener() {
        }

        public void notifyEvent(AccessibleEventObject accessibleEventObject) {
            switch (accessibleEventObject.EventId) {
                case 9: {
                    break;
                }
                default: {
                    super.notifyEvent(accessibleEventObject);
                }
            }
        }
    }
}

