/*
 * Decompiled with CFR 0.152.
 */
package transex3.controller;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import transex3.model.SdfEntity;
import transex3.model.SdfString;
import transex3.view.Editor;

public class EditorController {
    public final String[] RESTYPES = new String[]{".src", ".hrc", ".xcu", ".xrm", ".xhp"};
    public final String RECFILE = ".recommand";
    static Editor aEditor = null;
    static Vector sdfstrings = new Vector();
    static HashMap hashedsdfstrings = new HashMap();
    int oldindex = 0;

    public String fetchSourceStrings(String string) {
        File file = null;
        try {
            file = File.createTempFile("receditor", "tmp");
        }
        catch (IOException iOException) {
            System.err.println("Can not create temp file\n");
            iOException.printStackTrace();
        }
        String string2 = file.getAbsolutePath();
        try {
            System.out.println("localize_sl -QQ -skip_links -e -l en-US -f " + string2);
            Process process = Runtime.getRuntime().exec("localize_sl -QQ -skip_links -e -l en-US -f " + string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string3 = bufferedReader.readLine();
            while (string3 != null && string3.length() > 0) {
                string3 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string2;
    }

    public void findRecommandFiles(File file, Vector vector) {
        System.out.print(".");
        System.out.flush();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; fileArray.length > i; ++i) {
                if (fileArray[i].isDirectory() && !fileArray[i].getAbsolutePath().endsWith(".lnk")) {
                    this.findRecommandFiles(fileArray[i], vector);
                    continue;
                }
                if (!fileArray[i].isFile() || !this.isRecommandFile(fileArray[i])) continue;
                vector.add(fileArray[i]);
            }
        }
    }

    private boolean isResourceType(File file) {
        String string = file.getName();
        boolean bl = false;
        for (int i = 0; i < this.RESTYPES.length; ++i) {
            if (!string.endsWith(this.RESTYPES[i])) continue;
            bl = true;
        }
        return bl;
    }

    private boolean isRecommandFile(File file) {
        return file.getName().endsWith(".recommand");
    }

    public void clearAllRows(JTable jTable) {
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            jTable.setValueAt(null, i, 0);
            jTable.setValueAt(null, i, 1);
            jTable.setValueAt(null, i, 2);
            jTable.setValueAt(null, i, 3);
            jTable.setValueAt(null, i, 4);
        }
    }

    void updateData() {
        JTable jTable = aEditor.getRectable();
        SdfString sdfString = (SdfString)sdfstrings.get(this.oldindex);
        Vector<SdfEntity> vector = new Vector<SdfEntity>();
        for (int i = 1; i < jTable.getRowCount(); ++i) {
            String string = (String)jTable.getValueAt(i, 0);
            String string2 = (String)jTable.getValueAt(i, 1);
            String string3 = (String)jTable.getValueAt(i, 2);
            String string4 = (String)jTable.getValueAt(i, 3);
            String string5 = (String)jTable.getValueAt(i, 4);
            if (string == null || string2 == null) continue;
            SdfEntity sdfEntity = new SdfEntity();
            sdfEntity.setLangid(string);
            sdfEntity.setText(string2);
            sdfEntity.setHelptext(string3);
            sdfEntity.setQuickhelptext(string4);
            sdfEntity.setTitle(string5);
            vector.add(sdfEntity);
            sdfString.setLanguageStrings(vector);
        }
    }

    public void initView() {
        Object[][] objectArray = new Object[sdfstrings.size()][4];
        Object[][] objectArray2 = new Object[100][5];
        Iterator iterator = sdfstrings.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            SdfString sdfString = (SdfString)iterator.next();
            objectArray[n][0] = sdfString.getSourceString().getProject() + "\\" + sdfString.getSourceString().getSource_file();
            objectArray[n][1] = sdfString.getSourceString().getGid();
            objectArray[n][2] = sdfString.getSourceString().getLid();
            objectArray[n][3] = sdfString.getSourceString().getText();
            if (n == 0) {
                objectArray2[0][0] = "en-US";
                objectArray2[0][1] = sdfString.getSourceString().getText();
                objectArray2[0][2] = sdfString.getSourceString().getHelptext();
                objectArray2[0][3] = sdfString.getSourceString().getQuickhelptext();
                objectArray2[0][4] = sdfString.getSourceString().getTitle();
                sdfString = (SdfString)sdfstrings.get(0);
                Vector vector = sdfString.getLanguageStrings();
                for (int i = 0; i < vector.size(); ++i) {
                    SdfEntity sdfEntity = (SdfEntity)vector.get(i);
                    objectArray2[i + 1][0] = sdfEntity.getLangid();
                    objectArray2[i + 1][1] = sdfEntity.getText();
                    objectArray2[i + 1][2] = sdfEntity.getHelptext();
                    objectArray2[i + 1][3] = sdfEntity.getQuickhelptext();
                    objectArray2[i + 1][4] = sdfEntity.getTitle();
                }
            }
            ++n;
        }
        aEditor = new Editor(objectArray, objectArray2);
        aEditor.setBounds(100, 100, 800, 900);
        aEditor.setDefaultCloseOperation(2);
        aEditor.setVisible(true);
        aEditor.repaint();
        aEditor.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        aEditor.getMiExit().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        aEditor.getMiSave().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Iterator iterator = sdfstrings.iterator();
                String string = "";
                while (iterator.hasNext()) {
                    SdfString sdfString = (SdfString)iterator.next();
                    if (sdfString.getFileId().compareTo(string) != 0) {
                        // empty if block
                    }
                    sdfString.writeString();
                    string = sdfString.getFileId();
                }
            }
        });
        aEditor.getRectable().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent focusEvent) {
                JTable jTable = aEditor.getRectable();
                if (jTable.getSelectedRow() != -1 && jTable.getSelectedColumn() != -1) {
                    jTable.getCellEditor(jTable.getSelectedRow(), jTable.getSelectedColumn()).stopCellEditing();
                }
                EditorController.this.updateData();
            }

            public void focusGained(FocusEvent focusEvent) {
            }
        });
        aEditor.getRectable().getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
            }
        });
        aEditor.getRectable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JTable jTable = aEditor.getRectable();
                EditorController.this.updateData();
            }
        });
        aEditor.getTable().setSelectionMode(0);
        aEditor.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JTable jTable = aEditor.getTable();
                JTable jTable2 = aEditor.getRectable();
                JTable jTable3 = aEditor.getRectable();
                if (jTable3.getSelectedRow() != -1 && jTable3.getSelectedColumn() != -1) {
                    jTable3.getCellEditor(jTable3.getSelectedRow(), jTable3.getSelectedColumn()).stopCellEditing();
                }
                EditorController.this.updateData();
                EditorController.this.clearAllRows(jTable2);
                SdfString sdfString = (SdfString)sdfstrings.get(jTable.getSelectedRow());
                jTable2.setValueAt("en-US", 0, 0);
                jTable2.setValueAt(sdfString.getSourceString().getText(), 0, 1);
                jTable2.setValueAt(sdfString.getSourceString().getHelptext(), 0, 2);
                jTable2.setValueAt(sdfString.getSourceString().getQuickhelptext(), 0, 3);
                jTable2.setValueAt(sdfString.getSourceString().getTitle(), 0, 4);
                Vector vector = sdfString.getLanguageStrings();
                for (int i = 0; i < vector.size(); ++i) {
                    SdfEntity sdfEntity = (SdfEntity)vector.get(i);
                    jTable2.setValueAt(sdfEntity.getLangid(), i + 1, 0);
                    jTable2.setValueAt(sdfEntity.getText(), i + 1, 1);
                    jTable2.setValueAt(sdfEntity.getHelptext(), i + 1, 2);
                    jTable2.setValueAt(sdfEntity.getQuickhelptext(), i + 1, 3);
                    jTable2.setValueAt(sdfEntity.getTitle(), i + 1, 4);
                }
                EditorController.this.oldindex = jTable.getSelectedRow();
            }
        });
    }

    public void initInitialStrings() {
        String string = System.getProperty("SOLARSRC");
        String string2 = null;
        Vector vector = new Vector();
        string2 = this.fetchSourceStrings(string);
        this.readStrings(string2, vector);
        File file = new File(string2);
        file.delete();
        this.initView();
        aEditor.repaint();
    }

    public void readStrings(String string, Vector vector) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine();
            SdfString sdfString = null;
            SdfEntity sdfEntity = null;
            while (string2 != null) {
                sdfEntity = new SdfEntity();
                sdfEntity.setProperties(string2);
                sdfString = new SdfString();
                sdfString.addSourceString(sdfEntity);
                hashedsdfstrings.put(sdfString.getId(), sdfString);
                sdfstrings.add(sdfString);
                string2 = bufferedReader.readLine();
            }
            Iterator iterator = vector.iterator();
            BufferedReader bufferedReader2 = null;
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                bufferedReader2 = new BufferedReader(new FileReader(file));
                String string3 = bufferedReader2.readLine();
                while (string3 != null) {
                    SdfEntity sdfEntity2 = new SdfEntity();
                    sdfEntity2.setProperties(string3);
                    if (hashedsdfstrings.containsKey(sdfEntity2.getId())) {
                        sdfString = (SdfString)hashedsdfstrings.get(sdfEntity2.getId());
                        sdfString.addLanguageString(sdfEntity2);
                    } else {
                        System.out.println("DBG: Can't find source string '" + sdfEntity2.getId() + "'");
                    }
                    string3 = bufferedReader2.readLine();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

