/*
 * Decompiled with CFR 0.152.
 */
import com.sun.star.geometry.IntegerPoint2D;
import com.sun.star.geometry.IntegerRectangle2D;
import com.sun.star.geometry.IntegerSize2D;
import com.sun.star.geometry.RealRectangle2D;
import com.sun.star.geometry.RealSize2D;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.rendering.IntegerBitmapLayout;
import com.sun.star.rendering.RenderState;
import com.sun.star.rendering.ViewState;
import com.sun.star.rendering.VolatileContentDestroyedException;
import com.sun.star.rendering.XBitmap;
import com.sun.star.rendering.XBitmapCanvas;
import com.sun.star.rendering.XBitmapPalette;
import com.sun.star.rendering.XIntegerBitmap;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class CanvasBitmap
extends CanvasBase
implements XServiceInfo,
XBitmapCanvas,
XIntegerBitmap {
    private BufferedImage bitmap;
    private Graphics2D graphics;
    private static final String s_implName = "XIntegerBitmap.java.impl";
    private static final String s_serviceName = "com.sun.star.rendering.IntegerBitmap";

    public CanvasBitmap(BufferedImage bufferedImage) {
        this.bitmap = bufferedImage;
        this.graphics = this.bitmap.createGraphics();
    }

    public CanvasBitmap(IntegerSize2D integerSize2D) {
        this.bitmap = new BufferedImage(integerSize2D.Width, integerSize2D.Height, 6);
        this.graphics = this.bitmap.createGraphics();
    }

    public CanvasBitmap(RealSize2D realSize2D, boolean bl, CanvasBitmap canvasBitmap) {
    }

    public synchronized BufferedImage getBufferedImage() {
        return this.bitmap;
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    public synchronized IntegerSize2D getSize() {
        return new IntegerSize2D(this.bitmap.getWidth(), this.bitmap.getHeight());
    }

    public synchronized XBitmapCanvas queryBitmapCanvas() {
        return this;
    }

    public synchronized XBitmap getScaledBitmap(RealSize2D realSize2D, boolean bl) throws IllegalArgumentException, VolatileContentDestroyedException {
        return new CanvasBitmap(realSize2D, bl, this);
    }

    public synchronized boolean hasAlpha() {
        return false;
    }

    public synchronized void copyRect(XBitmapCanvas xBitmapCanvas, RealRectangle2D realRectangle2D, ViewState viewState, RenderState renderState, RealRectangle2D realRectangle2D2, ViewState viewState2, RenderState renderState2) {
        CanvasUtils.printLog("JavaCanvas.copyRect() called");
        if (xBitmapCanvas == this) {
            this.getGraphics().copyArea((int)realRectangle2D.X1, (int)realRectangle2D.Y1, (int)(realRectangle2D.X2 - realRectangle2D.X1), (int)(realRectangle2D.Y2 - realRectangle2D.Y1), (int)(realRectangle2D2.X1 - realRectangle2D.X1), (int)(realRectangle2D2.Y1 - realRectangle2D.Y1));
        } else if (xBitmapCanvas instanceof JavaCanvas) {
            CanvasUtils.setupGraphicsState(this.getGraphics(), viewState2, renderState2, (byte)0);
            Image image = ((JavaCanvas)xBitmapCanvas).backBuffer.getBackBuffer();
            this.getGraphics().drawImage(image, 0, 0, null);
            CanvasUtils.postRenderImageTreatment(image);
        }
    }

    public synchronized byte[] getData(IntegerBitmapLayout[] integerBitmapLayoutArray, IntegerRectangle2D integerRectangle2D) {
        int[] nArray = this.bitmap.getRGB(integerRectangle2D.X1, integerRectangle2D.Y1, integerRectangle2D.X2 - integerRectangle2D.X1, integerRectangle2D.Y1 - integerRectangle2D.Y2, null, 0, 0);
        return CanvasUtils.int2byte(nArray);
    }

    public synchronized void setData(byte[] byArray, IntegerBitmapLayout integerBitmapLayout, IntegerRectangle2D integerRectangle2D) {
        int[] nArray = CanvasUtils.byte2int(byArray);
        this.bitmap.setRGB(integerRectangle2D.X1, integerRectangle2D.Y1, integerRectangle2D.X2 - integerRectangle2D.X1, integerRectangle2D.Y2 - integerRectangle2D.Y1, nArray, 0, this.bitmap.getWidth());
    }

    public synchronized void setPixel(byte[] byArray, IntegerBitmapLayout integerBitmapLayout, IntegerPoint2D integerPoint2D) {
        if (byArray.length != 4) {
            CanvasUtils.printLog("CanvasBitmap.setPixel: Wrong color format");
        }
        int n = byArray[0] + (byArray[1] + (byArray[2] + byArray[3] * 256) * 256) * 256;
        this.bitmap.setRGB(integerPoint2D.X, integerPoint2D.Y, n);
    }

    public synchronized byte[] getPixel(IntegerBitmapLayout[] integerBitmapLayoutArray, IntegerPoint2D integerPoint2D) {
        int n = this.bitmap.getRGB(integerPoint2D.X, integerPoint2D.Y);
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n / 256 & 0xFF), (byte)(n / 256 / 256 & 0xFF), (byte)(n / 256 / 256 / 256 & 0xFF)};
        return byArray;
    }

    public synchronized XBitmapPalette getPalette() {
        return null;
    }

    public synchronized IntegerBitmapLayout getMemoryLayout() {
        IntegerBitmapLayout integerBitmapLayout = new IntegerBitmapLayout();
        return integerBitmapLayout;
    }

    public String getImplementationName() {
        return s_implName;
    }

    public String[] getSupportedServiceNames() {
        return new String[]{s_serviceName};
    }

    public boolean supportsService(String string) {
        return string.equals(s_serviceName);
    }
}

