/*
 * Decompiled with CFR 0.152.
 */
import com.sun.star.beans.PropertyValue;
import com.sun.star.geometry.Matrix2D;
import com.sun.star.geometry.RealBezierSegment2D;
import com.sun.star.geometry.RealPoint2D;
import com.sun.star.geometry.XMapping2D;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lib.uno.helper.ComponentBase;
import com.sun.star.rendering.FontInfo;
import com.sun.star.rendering.FontRequest;
import com.sun.star.rendering.RenderState;
import com.sun.star.rendering.StringContext;
import com.sun.star.rendering.StrokeAttributes;
import com.sun.star.rendering.Texture;
import com.sun.star.rendering.ViewState;
import com.sun.star.rendering.VolatileContentDestroyedException;
import com.sun.star.rendering.XBitmap;
import com.sun.star.rendering.XCachedPrimitive;
import com.sun.star.rendering.XCanvas;
import com.sun.star.rendering.XCanvasFont;
import com.sun.star.rendering.XGraphicDevice;
import com.sun.star.rendering.XPolyPolygon2D;
import com.sun.star.rendering.XTextLayout;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public abstract class CanvasBase
extends ComponentBase
implements XCanvas {
    public abstract Graphics2D getGraphics();

    public synchronized void clear() {
        Graphics2D graphics2D = this.getGraphics();
        graphics2D.clearRect(0, 0, 1000, 1000);
    }

    public synchronized void drawPoint(RealPoint2D realPoint2D, ViewState viewState, RenderState renderState) throws IllegalArgumentException {
        AffineTransform affineTransform;
        Graphics2D graphics2D = this.getGraphics();
        CanvasUtils.setupGraphicsState(graphics2D, viewState, renderState, (byte)0);
        AffineTransform affineTransform2 = graphics2D.getTransform();
        try {
            affineTransform = affineTransform2.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return;
        }
        Point2D.Double double_ = new Point2D.Double(1.0, 1.0);
        Point2D.Double double_2 = new Point2D.Double();
        affineTransform.deltaTransform(double_, double_2);
        Ellipse2D.Double double_3 = new Ellipse2D.Double(realPoint2D.X, realPoint2D.Y, double_2.x, double_2.y);
        graphics2D.fill(double_3);
        CanvasUtils.printLog("XCanvas: drawPoint called");
    }

    public synchronized void drawLine(RealPoint2D realPoint2D, RealPoint2D realPoint2D2, ViewState viewState, RenderState renderState) throws IllegalArgumentException {
        Graphics2D graphics2D = this.getGraphics();
        CanvasUtils.setupGraphicsState(graphics2D, viewState, renderState, (byte)0);
        graphics2D.setStroke(new BasicStroke());
        Line2D.Double double_ = new Line2D.Double(realPoint2D.X, realPoint2D.Y, realPoint2D2.X, realPoint2D2.Y);
        graphics2D.draw(double_);
        CanvasUtils.printLog("XCanvas: drawLine called");
    }

    public synchronized void drawBezier(RealBezierSegment2D realBezierSegment2D, RealPoint2D realPoint2D, ViewState viewState, RenderState renderState) throws IllegalArgumentException {
        Graphics2D graphics2D = this.getGraphics();
        CanvasUtils.setupGraphicsState(graphics2D, viewState, renderState, (byte)0);
        graphics2D.setStroke(new BasicStroke());
        CubicCurve2D.Double double_ = new CubicCurve2D.Double(realBezierSegment2D.Px, realBezierSegment2D.Py, realBezierSegment2D.C1x, realBezierSegment2D.C1y, realBezierSegment2D.C2x, realBezierSegment2D.C2y, realPoint2D.X, realPoint2D.Y);
        graphics2D.draw(double_);
        CanvasUtils.printLog("XCanvas: drawbezier called");
    }

    public synchronized XCachedPrimitive drawPolyPolygon(XPolyPolygon2D xPolyPolygon2D, ViewState viewState, RenderState renderState) throws IllegalArgumentException {
        CanvasUtils.printLog("CanvasBase.drawPolyPolygon() called");
        Graphics2D graphics2D = this.getGraphics();
        CanvasUtils.setupGraphicsState(graphics2D, viewState, renderState, (byte)0);
        graphics2D.setStroke(new BasicStroke());
        graphics2D.draw(CanvasUtils.makeGeneralPath(xPolyPolygon2D));
        CanvasUtils.printLog("XCanvas: drawPolyPolygon called");
        return null;
    }

    public synchronized XCachedPrimitive strokePolyPolygon(XPolyPolygon2D xPolyPolygon2D, ViewState viewState, RenderState renderState, StrokeAttributes strokeAttributes) throws IllegalArgumentException {
        Graphics2D graphics2D = this.getGraphics();
        CanvasUtils.setupGraphicsState(graphics2D, viewState, renderState, (byte)0);
        CanvasUtils.applyStrokeAttributes(graphics2D, strokeAttributes);
        graphics2D.draw(CanvasUtils.makeGeneralPath(xPolyPolygon2D));
        CanvasUtils.printLog("XCanvas: strokePolyPolygon called");
        return null;
    }

    public synchronized XCachedPrimitive strokeTexturedPolyPolygon(XPolyPolygon2D xPolyPolygon2D, ViewState viewState, RenderState renderState, Texture[] textureArray, StrokeAttributes strokeAttributes) throws IllegalArgumentException, VolatileContentDestroyedException {
        return null;
    }

    public synchronized XCachedPrimitive strokeTextureMappedPolyPolygon(XPolyPolygon2D xPolyPolygon2D, ViewState viewState, RenderState renderState, Texture[] textureArray, XMapping2D xMapping2D, StrokeAttributes strokeAttributes) throws IllegalArgumentException, VolatileContentDestroyedException {
        return null;
    }

    public synchronized XPolyPolygon2D queryStrokeShapes(XPolyPolygon2D xPolyPolygon2D, ViewState viewState, RenderState renderState, StrokeAttributes strokeAttributes) throws IllegalArgumentException {
        return null;
    }

    public synchronized XCachedPrimitive fillPolyPolygon(XPolyPolygon2D xPolyPolygon2D, ViewState viewState, RenderState renderState) throws IllegalArgumentException {
        CanvasUtils.printLog("CanvasBase.fillPolyPolygon() called");
        Graphics2D graphics2D = this.getGraphics();
        CanvasUtils.setupGraphicsState(graphics2D, viewState, renderState, (byte)0);
        graphics2D.fill(CanvasUtils.makeGeneralPath(xPolyPolygon2D));
        CanvasUtils.printLog("XCanvas: fillPolyPolygon called");
        return null;
    }

    public synchronized XCachedPrimitive fillTexturedPolyPolygon(XPolyPolygon2D xPolyPolygon2D, ViewState viewState, RenderState renderState, Texture[] textureArray) throws IllegalArgumentException {
        return null;
    }

    public synchronized XCachedPrimitive fillTextureMappedPolyPolygon(XPolyPolygon2D xPolyPolygon2D, ViewState viewState, RenderState renderState, Texture[] textureArray, XMapping2D xMapping2D) throws IllegalArgumentException, VolatileContentDestroyedException {
        return null;
    }

    public synchronized XCanvasFont createFont(FontRequest fontRequest, PropertyValue[] propertyValueArray, Matrix2D matrix2D) throws IllegalArgumentException {
        return new CanvasFont(fontRequest, this);
    }

    public FontInfo[] queryAvailableFonts(FontInfo fontInfo, PropertyValue[] propertyValueArray) throws IllegalArgumentException {
        return null;
    }

    public XCachedPrimitive drawText(StringContext stringContext, XCanvasFont xCanvasFont, ViewState viewState, RenderState renderState, byte by) throws IllegalArgumentException {
        CanvasUtils.printLog("CanvasBase.drawText() called");
        Graphics2D graphics2D = this.getGraphics();
        CanvasUtils.printLog("XCanvas: drawText called");
        CanvasUtils.setupGraphicsState(graphics2D, viewState, renderState, (byte)0);
        CanvasUtils.setupGraphicsFont(graphics2D, viewState, renderState, xCanvasFont);
        CanvasUtils.printLog("XCanvas: drawText rendering \"" + stringContext.Text.substring(stringContext.StartPosition, stringContext.StartPosition + stringContext.Length) + "\"");
        graphics2D.drawString(stringContext.Text.substring(stringContext.StartPosition, stringContext.StartPosition + stringContext.Length), 0.0f, 0.0f);
        return null;
    }

    public XCachedPrimitive drawTextLayout(XTextLayout xTextLayout, ViewState viewState, RenderState renderState) throws IllegalArgumentException {
        CanvasUtils.printLog("CanvasBase.drawOffsettedText() called");
        Graphics2D graphics2D = this.getGraphics();
        CanvasUtils.printLog("XCanvas: drawOffsettedText called");
        CanvasUtils.setupGraphicsState(graphics2D, viewState, renderState, (byte)0);
        CanvasUtils.setupGraphicsFont(graphics2D, viewState, renderState, xTextLayout.getFont());
        CanvasUtils.printLog("XCanvas: drawOffsettedText canvas setup done");
        if (!(xTextLayout instanceof TextLayout)) {
            CanvasUtils.printLog("drawTextLayout: mismatching TextLayout object.");
            throw new IllegalArgumentException();
        }
        ((TextLayout)xTextLayout).draw(graphics2D);
        return null;
    }

    public synchronized XCachedPrimitive drawBitmap(XBitmap xBitmap, ViewState viewState, RenderState renderState) throws IllegalArgumentException {
        CanvasUtils.printLog("CanvasBase.drawBitmap() called");
        Graphics2D graphics2D = this.getGraphics();
        CanvasUtils.setupGraphicsState(graphics2D, viewState, renderState, (byte)0);
        BufferedImage bufferedImage = CanvasUtils.getBufferedImage(xBitmap);
        if (!graphics2D.drawImage((Image)bufferedImage, 0, 0, null)) {
            CanvasUtils.printLog("CanvasBase.drawBitmap: image paint incomplete");
        }
        CanvasUtils.postRenderImageTreatment(bufferedImage);
        return null;
    }

    public synchronized XCachedPrimitive drawBitmapModulated(XBitmap xBitmap, ViewState viewState, RenderState renderState) throws IllegalArgumentException {
        CanvasUtils.printLog("CanvasBase.drawBitmapModulated() called");
        return this.drawBitmap(xBitmap, viewState, renderState);
    }

    public synchronized XGraphicDevice getDevice() {
        CanvasUtils.printLog("CanvasBase.getDevice() called");
        return new CanvasGraphicDevice(this.getGraphics());
    }
}

