/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.sun.star.beans.Property;
import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.ucb.InteractiveAugmentedIOException;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.URL;
import com.sun.star.util.XMacroExpander;
import com.sun.star.util.XURLTransformer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;

public class utils {
    public static String getFullTestDocName(String string) {
        String string2 = System.getProperty("DOCPTH");
        if (string2.endsWith("\\") || string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string2.startsWith("http:")) {
            return string2 + "/" + string;
        }
        String string3 = "";
        String string4 = System.getProperty("file.separator");
        if (string2 == null) {
            String string5 = System.getProperty("OBJDSCS");
            int n = string5.indexOf("objdsc");
            String string6 = string5.substring(0, n - 1);
            string3 = string6 + string4 + "doc" + string4 + "java" + string4 + "testdocs" + string4 + string;
        } else {
            string3 = string2 + string4 + string;
        }
        return string3;
    }

    public static String getFullTestURL(String string) {
        Object object;
        String string2 = utils.getFullTestDocName(string);
        if (string2.startsWith("http:")) {
            return string2;
        }
        if (string2.startsWith("file:")) {
            return string2;
        }
        String string3 = null;
        if (string2.startsWith("\\\\")) {
            string3 = "file:";
        }
        string2 = string2.replace('\\', '/');
        if (string3 == null) {
            string3 = string2.startsWith("//") ? "file:/" : (string2.startsWith("/") ? "file://" : "file:///");
        }
        if (!string2.endsWith("/") && ((File)(object = new File(string2))).isDirectory()) {
            string2 = string2 + "/";
        }
        object = string3 + string2;
        return object;
    }

    public static String getFullURL(String string) {
        Object object;
        String string2 = string;
        if ((string2 = string2.replace('\\', '/')).startsWith("http:")) {
            return string2;
        }
        if (string2.startsWith("ftp:")) {
            return string2;
        }
        String string3 = "";
        if (!string2.startsWith("file:///")) {
            string3 = string2.startsWith("//") ? "file:" : (string2.startsWith("/") ? "file://" : "file:///");
        }
        if (!string2.endsWith("/") && ((File)(object = new File(string2))).isDirectory()) {
            string2 = string2 + "/";
        }
        object = string3 + string2;
        return object;
    }

    public static void make_Directories(String string, String string2) {
        String string3 = null;
        String string4 = System.getProperty("file.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string4, false);
        string3 = string;
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            File file = new File(string3 + File.separatorChar + string5);
            string3 = file.toString();
            file.mkdirs();
        }
    }

    public static String getVersion(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            return "/";
        }
        File file = new File(string);
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            String string4 = "";
            while (!string4.equals("[" + string3.toUpperCase() + "]")) {
                string4 = randomAccessFile.readLine();
            }
            string4 = "=/";
            while (!string4.startsWith(string2) || string4.startsWith("[")) {
                string4 = randomAccessFile.readLine();
            }
            randomAccessFile.close();
            if (string4.startsWith("[")) {
                string4 = "/";
            }
            return string4.substring(string4.indexOf("=") + 1);
        }
        catch (Exception exception) {
            System.out.println("Couldn't find version");
            return "/";
        }
    }

    public static String getOfficeUserPath(XMultiServiceFactory xMultiServiceFactory) {
        int n;
        String string = null;
        try {
            string = utils.getOfficeSettingsValue(xMultiServiceFactory, "UserConfig");
        }
        catch (Exception exception) {
            System.out.println("Couldn't get Office User Path");
            exception.printStackTrace();
        }
        if (string.charAt(string.length() - 1) == '/') {
            string = string.substring(0, string.length() - 1);
        }
        if ((n = string.lastIndexOf(47)) != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static String getOfficeSettingsValue(XMultiServiceFactory xMultiServiceFactory, String string) {
        String string2 = null;
        try {
            Object object = xMultiServiceFactory.createInstance("com.sun.star.comp.framework.PathSettings");
            XPropertySet xPropertySet = null;
            try {
                xPropertySet = (XPropertySet)AnyConverter.toObject((Type)new Type(XPropertySet.class), (Object)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println("### couldn't get Office Settings");
            }
            string2 = (String)xPropertySet.getPropertyValue(string);
        }
        catch (Exception exception) {
            System.out.println("Couldn't get stting value for " + string);
            exception.printStackTrace();
        }
        return string2;
    }

    public static void setOfficeSettingsValue(XMultiServiceFactory xMultiServiceFactory, String string, String string2) {
        Object var3_3 = null;
        try {
            Object object = xMultiServiceFactory.createInstance("com.sun.star.comp.framework.PathSettings");
            XPropertySet xPropertySet = null;
            try {
                xPropertySet = (XPropertySet)AnyConverter.toObject((Type)new Type(XPropertySet.class), (Object)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println("### couldn't get Office Settings");
            }
            xPropertySet.setPropertyValue(string, string2);
        }
        catch (Exception exception) {
            System.out.println("Couldn't set '" + string + "' to value '" + string2 + "'");
            exception.printStackTrace();
        }
    }

    public static String getUsersTempDir() {
        String string = System.getProperty("my.temp");
        if (string == null && (string = System.getProperty("my.tmp")) == null) {
            string = System.getProperty("java.io.tmpdir");
        }
        if (string.endsWith(System.getProperty("file.separator"))) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String getOfficeTemp(XMultiServiceFactory xMultiServiceFactory) {
        String string = utils.getUsersTempDir();
        try {
            String string2 = utils.getOfficeSettingsValue(xMultiServiceFactory, "Temp");
            if (!string2.endsWith(System.getProperty("file.separator"))) {
                string2 = string2 + System.getProperty("file.separator");
            }
            string = utils.getFullURL(string2);
        }
        catch (Exception exception) {
            System.out.println("Couldn't get Office TEMP");
            exception.printStackTrace();
        }
        return string;
    }

    public static String getOfficeTempDir(XMultiServiceFactory xMultiServiceFactory) {
        boolean bl;
        String string = utils.getOfficeTemp(xMultiServiceFactory);
        int n = string.indexOf("file:///");
        if (n < 0) {
            return string;
        }
        string = string.substring("file:///".length());
        n = string.indexOf(":");
        boolean bl2 = bl = string.endsWith("/") || string.endsWith("\\");
        if (n < 0) {
            string = "/" + string;
            string = string + (bl ? "" : "/");
        } else {
            string = string + (bl ? "" : "\\");
        }
        return string;
    }

    public static String getOfficeTempDirSys(XMultiServiceFactory xMultiServiceFactory) {
        String string = utils.getOfficeTemp(xMultiServiceFactory);
        String string2 = "";
        int n = string.indexOf("file://");
        string2 = n < 0 ? string : string.substring("file://".length());
        if (string2.charAt(string2.length() - 1) != '/') {
            string2 = string2 + "/";
        }
        if (string2.indexOf(":") != -1) {
            string2 = string2.substring(1);
            string2 = string2.replace('/', '\\');
        }
        return string2;
    }

    public static String getSystemURL(String string) {
        String string2 = "";
        int n = string.indexOf("file://");
        string2 = n < 0 ? string : string.substring("file://".length());
        if (string2.indexOf(":") != -1) {
            string2 = string2.substring(1);
            string2 = string2.replace('/', '\\');
        }
        return string2;
    }

    public static boolean fileExists(XMultiServiceFactory xMultiServiceFactory, String string) {
        boolean bl = false;
        try {
            Object object = xMultiServiceFactory.createInstance("com.sun.star.comp.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, object);
            if (xSimpleFileAccess.exists(string)) {
                bl = true;
            }
        }
        catch (Exception exception) {
            System.out.println("Couldn't access file '" + string + "'");
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    public static boolean deleteFile(XMultiServiceFactory xMultiServiceFactory, String string) {
        boolean bl = true;
        try {
            Object object = xMultiServiceFactory.createInstance("com.sun.star.comp.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, object);
            if (xSimpleFileAccess.exists(string)) {
                xSimpleFileAccess.kill(string);
            }
        }
        catch (Exception exception) {
            System.out.println("Couldn't delete file '" + string + "'");
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    public static boolean copyFile(XMultiServiceFactory xMultiServiceFactory, String string, String string2) {
        boolean bl = false;
        try {
            Object object = xMultiServiceFactory.createInstance("com.sun.star.comp.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, object);
            if (!xSimpleFileAccess.exists(string2)) {
                xSimpleFileAccess.copy(string, string2);
            }
            bl = true;
        }
        catch (Exception exception) {
            System.out.println("Couldn't copy file '" + string + "' -> '" + string2 + "'");
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    public static boolean overwriteFile(XMultiServiceFactory xMultiServiceFactory, String string, String string2) {
        boolean bl = false;
        try {
            Object object = xMultiServiceFactory.createInstance("com.sun.star.comp.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, object);
            if (xSimpleFileAccess.exists(string2)) {
                xSimpleFileAccess.kill(string2);
            }
            xSimpleFileAccess.copy(string, string2);
            bl = true;
        }
        catch (InteractiveAugmentedIOException interactiveAugmentedIOException) {
            return false;
        }
        catch (com.sun.star.uno.Exception exception) {
            System.out.println("Couldn't create a service.");
            exception.printStackTrace();
        }
        return bl;
    }

    public static boolean hasPropertyByName(XPropertySet xPropertySet, String string) {
        Property[] propertyArray = xPropertySet.getPropertySetInfo().getProperties();
        boolean bl = false;
        for (int i = 0; i < propertyArray.length; ++i) {
            String string2 = propertyArray[i].Name;
            if (!string.equals(string2)) continue;
            bl = true;
        }
        return bl;
    }

    public static String getImplName(Object object) {
        String string = "Error getting Implementation name";
        try {
            XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, object);
            string = xServiceInfo.getImplementationName();
        }
        catch (Exception exception) {
            string = "Error getting Implementation name ( " + exception + " )";
        }
        return string;
    }

    public static boolean isVoid(Object object) {
        if (object instanceof Any) {
            Any any = (Any)object;
            return any.getType().getTypeName().equals("void");
        }
        return false;
    }

    public static String replacePart(String string, String string2, String string3) {
        return utils.replaceAll13(string, string2, string3);
    }

    public static int getNextFreePort(int n) {
        if (n < 1024) {
            n = 10000;
        }
        for (int i = n; i < 65536; ++i) {
            Closeable closeable;
            System.out.println("Scan port " + i);
            try {
                closeable = new ServerSocket(i);
                closeable.close();
            }
            catch (IOException iOException) {
                System.out.println(" -> server: occupied port " + i);
                continue;
            }
            try {
                closeable = new Socket("localhost", i);
                System.out.println(" -> socket: occupied port: " + i);
                continue;
            }
            catch (IOException iOException) {
                System.out.println(" -> free port");
                return i;
            }
        }
        return 65535;
    }

    public static URL parseURL(XMultiServiceFactory xMultiServiceFactory, String string) {
        URL[] uRLArray = new URL[]{new URL()};
        uRLArray[0].Complete = string;
        XURLTransformer xURLTransformer = null;
        try {
            Object object = xMultiServiceFactory.createInstance("com.sun.star.util.URLTransformer");
            xURLTransformer = (XURLTransformer)UnoRuntime.queryInterface(XURLTransformer.class, object);
        }
        catch (com.sun.star.uno.Exception exception) {
            // empty catch block
        }
        xURLTransformer.parseStrict(uRLArray);
        return uRLArray[0];
    }

    public static String getOfficeURL(XMultiServiceFactory xMultiServiceFactory) {
        try {
            Object object = xMultiServiceFactory.createInstance("com.sun.star.util.PathSettings");
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, object);
            String string = (String)xPropertySet.getPropertyValue("Module");
            return string;
        }
        catch (Exception exception) {
            System.out.println("Couldn't get Office Settings ");
            exception.printStackTrace();
            return null;
        }
    }

    public static String getOfficeBinPath(XMultiServiceFactory xMultiServiceFactory) {
        String string = "";
        try {
            string = utils.getSystemURL(utils.expandMacro(xMultiServiceFactory, "$SYSBINDIR"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static String[] getFilteredPropertyNames(XPropertySet xPropertySet, short s, short s2) {
        Property[] propertyArray = xPropertySet.getPropertySetInfo().getProperties();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < propertyArray.length; ++i) {
            boolean bl;
            boolean bl2 = (propertyArray[i].Attributes & s2) != 0;
            boolean bl3 = bl = s == 0 || (propertyArray[i].Attributes & s) != 0;
            if (!bl || bl2) continue;
            arrayList.add(propertyArray[i].Name);
        }
        Collections.sort(arrayList);
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    public static void shortWait(int n) {
        try {
            Thread.currentThread();
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("While waiting :" + interruptedException);
        }
    }

    public static String validateAppExecutionCommand(String string, String string2) {
        String string3 = "OK";
        string = utils.replaceAll13(string, "\"", "");
        string = utils.replaceAll13(string, "'", "");
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
        String string4 = "";
        String string5 = "soffice";
        int n = -1;
        while (stringTokenizer.hasMoreTokens() && n == -1) {
            string4 = string4 + stringTokenizer.nextToken() + " ";
            n = string4.indexOf(string5);
        }
        if (n == -1) {
            string3 = "Error: Your 'AppExecutionCommand' parameter does not contain '" + string5 + "'.";
        } else {
            String string6 = (string4 = string4.trim()).substring(0, n);
            File file = new File(string6);
            if (!file.exists() || !file.isDirectory()) {
                string3 = "Error: Your 'AppExecutionCommand' parameter does not point to a valid system directory: " + string6;
            } else {
                file = new File(string4);
                if (!file.exists() || !file.isFile()) {
                    file = new File(string4 + ".exe");
                }
                if (!file.exists() || !file.isFile()) {
                    string3 = "Error: Your 'AppExecutionCommand' parameter does not point to a valid office installation.";
                } else {
                    boolean bl = true;
                    while (stringTokenizer.hasMoreElements()) {
                        String string7 = stringTokenizer.nextToken();
                        if (string7.indexOf("-accept=") == -1) continue;
                        bl = false;
                        string3 = utils.validateConnectString(string7, true);
                    }
                    if (bl) {
                        string3 = "Error: Your 'AppExecutionCommand' parameter does not contain a '-accept' parameter for connecting the office.";
                    }
                }
            }
        }
        return string3;
    }

    public static String validateConnectString(String string, boolean bl) {
        String string2 = "";
        if (bl) {
            string2 = "-accept=";
        }
        String string3 = "OK";
        if (string.indexOf("socket") != -1) {
            if (string.indexOf(string2 + "socket,host=") == -1 || string.indexOf("port=") == -1) {
                string3 = bl ? "Error: The '-accept' parameter contains a syntax error: It should be like: '-accept=socket,host=localhost,port=8100;urp;" : "Error: The 'ConnectionString' parameter contains a syntax error: It should be like: 'socket,host=localhost,port=8100'";
            }
        } else if (string.indexOf("pipe") != -1) {
            if (string.indexOf(string2 + "pipe,name=") == -1) {
                string3 = bl ? "Error: The '-accept' parameter contains a syntax error: It should be like: '-accept=pipe,name=myuniquename;urp;'" : "Error: The 'ConnectionString' parameter contains a syntax error: It should be like: 'pipe,name=myuniquename'";
            }
        } else {
            string3 = bl ? "Warning: The '-accept' parameter contains an unknown connection method." : "Warning: The 'ConnectionString' parameter contains an unknown connection method.";
        }
        return string3;
    }

    public static String replaceAll13(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = string2.length();
        int n2 = string3.length();
        int n3 = string.indexOf(string2);
        while (n3 != -1) {
            stringBuffer = stringBuffer.replace(n3, n3 + n, string3);
            string = stringBuffer.toString();
            n3 = string.indexOf(string2, n3 + n2);
        }
        return string;
    }

    public static String expandMacro(XMultiServiceFactory xMultiServiceFactory, String string) throws Exception {
        try {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMultiServiceFactory);
            XComponentContext xComponentContext = (XComponentContext)UnoRuntime.queryInterface(XComponentContext.class, xPropertySet.getPropertyValue("DefaultContext"));
            XMacroExpander xMacroExpander = (XMacroExpander)UnoRuntime.queryInterface(XMacroExpander.class, xComponentContext.getValueByName("/singletons/com.sun.star.util.theMacroExpander"));
            return xMacroExpander.expandMacros(string);
        }
        catch (Exception exception) {
            throw new Exception("could not expand macro: " + exception.toString(), exception);
        }
    }

    public static String getOfficeOS(XMultiServiceFactory xMultiServiceFactory) {
        String string = "unkown";
        try {
            String string2 = utils.expandMacro(xMultiServiceFactory, "$_OS");
            if (string2.equals("Windows")) {
                string = "wntmsci";
            } else if (string2.equals("Linux")) {
                string = "unxlngi";
            } else if (string2.equals("Solaris")) {
                String string3 = utils.expandMacro(xMultiServiceFactory, "$_ARCH");
                if (string3.equals("SPARC")) {
                    string = "unxsols";
                } else if (string3.equals("x86")) {
                    string = "unxsoli";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static void dispatchURL(XMultiServiceFactory xMultiServiceFactory, XComponent xComponent, String string) throws Exception {
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xComponent);
        XController xController = xModel.getCurrentController();
        utils.dispatchURL(xMultiServiceFactory, xController, string);
    }

    public static void dispatchURL(XMultiServiceFactory xMultiServiceFactory, XController xController, String string) throws Exception {
        try {
            XDispatchProvider xDispatchProvider = (XDispatchProvider)UnoRuntime.queryInterface(XDispatchProvider.class, (Object)xController);
            XURLTransformer xURLTransformer = (XURLTransformer)UnoRuntime.queryInterface(XURLTransformer.class, xMultiServiceFactory.createInstance("com.sun.star.util.URLTransformer"));
            URL[] uRLArray = new URL[]{new URL()};
            uRLArray[0].Complete = string;
            xURLTransformer.parseStrict(uRLArray);
            URL uRL = uRLArray[0];
            XDispatch xDispatch = xDispatchProvider.queryDispatch(uRL, "", 0);
            xDispatch.dispatch(uRL, null);
            utils.shortWait(3000);
        }
        catch (Exception exception) {
            throw new Exception("ERROR: could not dispatch URL '" + string + "': " + exception.toString());
        }
    }

    public static String getDateTime() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        DecimalFormat decimalFormat = new DecimalFormat("00");
        String string = decimalFormat.format(gregorianCalendar.get(5)) + "." + decimalFormat.format(gregorianCalendar.get(2) + 1) + "." + decimalFormat.format(gregorianCalendar.get(1)) + " - " + decimalFormat.format(gregorianCalendar.get(11)) + ":" + decimalFormat.format(gregorianCalendar.get(12)) + ":" + decimalFormat.format(gregorianCalendar.get(13)) + "," + decimalFormat.format(gregorianCalendar.get(14));
        return "[" + string + "]";
    }
}

