/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XTypeProvider;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import java.lang.reflect.Method;

public class dbg {
    public static void printInterfaces(XInterface xInterface) {
        dbg.printInterfaces(xInterface, false);
    }

    public static void printInterfaces(XInterface xInterface, boolean bl) {
        Type[] typeArray = dbg.getInterfaceTypes(xInterface);
        if (null != typeArray) {
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                System.out.println(typeArray[i].getTypeName());
                if (!bl) continue;
                dbg.printInterfaceInfo(typeArray[i]);
                System.out.println();
            }
        }
    }

    public static Type[] getInterfaceTypes(XInterface xInterface) {
        Type[] typeArray = null;
        XTypeProvider xTypeProvider = (XTypeProvider)UnoRuntime.queryInterface(XTypeProvider.class, (Object)xInterface);
        if (xTypeProvider != null) {
            typeArray = xTypeProvider.getTypes();
        }
        return typeArray;
    }

    public static boolean implementsInterface(XInterface xInterface, String string) {
        Type[] typeArray = dbg.getInterfaceTypes(xInterface);
        if (null != typeArray) {
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                if (!typeArray[i].getTypeName().toLowerCase().endsWith(string.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public static void printInterfaceInfo(Type type) {
        try {
            Class clazz = type.getZClass();
            Method[] methodArray = clazz.getDeclaredMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                System.out.println("\t" + methodArray[i].getReturnType().getName() + " " + methodArray[i].getName() + "()");
            }
        }
        catch (Exception exception) {
            System.out.println("Exception occured while printing InterfaceInfo");
            exception.printStackTrace();
        }
    }

    public static void printArray(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println(stringArray[i]);
        }
    }

    public static void printPropertyInfo(XPropertySet xPropertySet, String string) {
        dbg.printPropertyInfo(xPropertySet, string, new PrintWriter(System.out));
    }

    public static void printPropertyInfo(XPropertySet xPropertySet, String string, PrintWriter printWriter) {
        try {
            XPropertySetInfo xPropertySetInfo = xPropertySet.getPropertySetInfo();
            Property[] propertyArray = xPropertySetInfo.getProperties();
            Property property = xPropertySetInfo.getPropertyByName(string);
            printWriter.println("Property name is " + property.Name);
            printWriter.println("Property handle is " + property.Handle);
            printWriter.println("Property type is " + property.Type.getTypeName());
            printWriter.println("Property current value is " + xPropertySet.getPropertyValue(string));
            printWriter.println("Attributes :");
            short s = property.Attributes;
            if ((s & 2) != 0) {
                printWriter.println("\t-BOUND");
            }
            if ((s & 4) != 0) {
                printWriter.println("\t-CONSTRAINED");
            }
            if ((s & 0x20) != 0) {
                printWriter.println("\t-MAYBEAMBIGUOUS");
            }
            if ((s & 0x40) != 0) {
                printWriter.println("\t-MAYBEDEFAULT");
            }
            if ((s & 1) != 0) {
                printWriter.println("\t-MAYBEVOID");
            }
            if ((s & 0x10) != 0) {
                printWriter.println("\t-READONLY");
            }
            if ((s & 0x80) != 0) {
                printWriter.println("\t-REMOVEABLE");
            }
            if ((s & 8) != 0) {
                printWriter.println("\t-TRANSIENT");
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            printWriter.println("Exception!!!!");
            exception.printStackTrace(printWriter);
        }
    }

    public static void printProperyValueSequenzePairs(PropertyValue[] propertyValueArray) {
        for (int i = 0; i < propertyValueArray.length; ++i) {
            dbg.printProperyValuePairs(propertyValueArray[i], new PrintWriter(System.out));
        }
    }

    public static void printProperyValueSequenzePairs(PropertyValue[] propertyValueArray, PrintWriter printWriter) {
        for (int i = 0; i < propertyValueArray.length; ++i) {
            dbg.printProperyValuePairs(propertyValueArray[i], printWriter);
        }
    }

    public static void printProperyValuePairs(PropertyValue propertyValue) {
        dbg.printProperyValuePairs(propertyValue, new PrintWriter(System.out));
    }

    public static void printProperyValuePairs(PropertyValue propertyValue, PrintWriter printWriter) {
        if (propertyValue.Value instanceof String[]) {
            String[] stringArray = (String[])propertyValue.Value;
            String string = "value is an empty String[]";
            if (stringArray.length > 0) {
                string = "['";
                for (int i = 0; i < stringArray.length; ++i) {
                    string = string + stringArray[i];
                    if (i + 1 >= stringArray.length) continue;
                    string = string + "';'";
                }
                string = string + "']";
            }
            printWriter.println("--------");
            printWriter.println("   Name: '" + propertyValue.Name + "' contains String[]:");
            printWriter.println(string);
            printWriter.println("--------");
        } else if (propertyValue.Value instanceof PropertyValue) {
            printWriter.println("--------");
            printWriter.println("   Name: '" + propertyValue.Name + "' contains PropertyValue:");
            dbg.printProperyValuePairs((PropertyValue)propertyValue.Value, printWriter);
            printWriter.println("--------");
        } else if (propertyValue.Value instanceof PropertyValue[]) {
            printWriter.println("--------");
            printWriter.println("   Name: '" + propertyValue.Name + "' contains PropertyValue[]:");
            dbg.printProperyValueSequenzePairs((PropertyValue[])propertyValue.Value, printWriter);
            printWriter.println("--------");
        } else {
            printWriter.println("Name: '" + propertyValue.Name + "' Value: '" + propertyValue.Value.toString() + "'");
        }
    }

    public static void printPropertiesNames(XPropertySet xPropertySet) {
        XPropertySetInfo xPropertySetInfo = xPropertySet.getPropertySetInfo();
        Property[] propertyArray = xPropertySetInfo.getProperties();
        for (int i = 0; i < propertyArray.length; ++i) {
            System.out.println(i + ".  " + propertyArray[i].Name);
        }
    }

    public static void getSuppServices(Object object) {
        XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, object);
        dbg.printArray(xServiceInfo.getSupportedServiceNames());
        String string = "Therein not Supported Service";
        boolean bl = false;
        for (int i = 0; i < xServiceInfo.getSupportedServiceNames().length; ++i) {
            if (xServiceInfo.supportsService(xServiceInfo.getSupportedServiceNames()[i])) continue;
            bl = true;
            string = string + "\n" + xServiceInfo.getSupportedServiceNames()[i];
        }
        if (bl) {
            System.out.println(string);
        }
    }

    public static String getImplID(XInterface xInterface) {
        String string = "";
        XTypeProvider xTypeProvider = (XTypeProvider)UnoRuntime.queryInterface(XTypeProvider.class, (Object)xInterface);
        if (xTypeProvider != null) {
            byte[] byArray = xTypeProvider.getImplementationId();
            string = "ImplementationID: ";
            for (int i = 0; i < byArray.length; ++i) {
                Byte by = new Byte(byArray[i]);
                string = string + by.intValue();
            }
        } else {
            string = "No Implementation ID available";
        }
        return string;
    }
}

