/*
 * Decompiled with CFR 0.152.
 */
package helper;

import helper.OfficeWatcher;
import helper.Pump;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import lib.TestParameters;
import util.utils;

public class ProcessHandler {
    private String cmdLine;
    private String[] cmdLineArray;
    private String[] envVars = null;
    private File workDir = null;
    private PrintWriter log;
    private int exitValue = -1;
    private boolean isFinished = false;
    private boolean isStarted = false;
    private boolean mbTimedOut = false;
    private long mTimeOut = 0L;
    private String stdInBuff = "";
    private Pump stdout = null;
    private Pump stderr = null;
    private PrintStream stdIn = null;
    private Process proc = null;
    private TestParameters param = null;
    private boolean debug = false;

    public ProcessHandler(String string) {
        this(string, null, null, null, 0L);
    }

    public ProcessHandler(String[] stringArray) {
        this(null, null, null, null, 0L);
        this.cmdLineArray = stringArray;
    }

    public ProcessHandler(String[] stringArray, String[] stringArray2) {
        this(null, null, null, stringArray2, 0L);
        this.cmdLineArray = stringArray;
    }

    public ProcessHandler(String[] stringArray, File file) {
        this(null, null, file, null, 0L);
        this.cmdLineArray = stringArray;
    }

    public ProcessHandler(String[] stringArray, PrintWriter printWriter, File file) {
        this(null, printWriter, file, null, 0L);
        this.cmdLineArray = stringArray;
    }

    public ProcessHandler(String string, PrintWriter printWriter) {
        this(string, printWriter, null, null, 0L);
    }

    public ProcessHandler(String string, int n) {
        this(string, null, null, null, n);
    }

    public ProcessHandler(String string, File file) {
        this(string, null, file, null, 0L);
    }

    public ProcessHandler(String string, PrintWriter printWriter, File file) {
        this(string, printWriter, file, null, 0L);
    }

    public ProcessHandler(String string, PrintWriter printWriter, File file, String[] stringArray) {
        this(string, printWriter, file, stringArray, 0L);
    }

    public ProcessHandler(String string, PrintWriter printWriter, File file, String[] stringArray, long l) {
        this.cmdLine = string;
        this.workDir = file;
        this.log = printWriter;
        this.cmdLine = string;
        this.envVars = stringArray;
        this.log = printWriter == null ? new PrintWriter(new OutputStreamWriter(System.out)) : printWriter;
        this.mTimeOut = l;
    }

    public ProcessHandler(String[] stringArray, PrintWriter printWriter, File file, boolean bl, TestParameters testParameters) {
        this(null, printWriter, file, null, 0L);
        this.cmdLineArray = stringArray;
        this.param = testParameters;
        this.mTimeOut = bl ? 5000L : (long)((double)testParameters.getInt("TimeOut") / 1.3);
        this.debug = testParameters.getBool("DebugIsActive");
    }

    public void runCommand() {
        boolean bl = true;
        int n = 0;
        String string = "";
        this.executeAsynchronously();
        OfficeWatcher officeWatcher = null;
        if (this.param != null) {
            officeWatcher = (OfficeWatcher)this.param.get("Watcher");
        }
        while (bl && !this.isFinished()) {
            ++n;
            if (officeWatcher != null) {
                officeWatcher.ping();
            }
            this.dbg("runCommand: waiting " + this.mTimeOut / 1000L + " seconds while command execution is ongoing... " + n);
            ProcessHandler.shortWait(this.mTimeOut);
            if (officeWatcher != null) {
                officeWatcher.ping();
            }
            if (this.isFinished()) continue;
            if (this.getOutputText().equals(string)) {
                bl = false;
                this.dbg("runCommand Could not detect changes in output stream!!!");
            }
            string = this.getOutputText();
        }
        if (!this.isFinished()) {
            this.dbg("runCommand Process ist not finished but there are no changes in output stream.");
            this.kill();
        }
    }

    public boolean isTimedOut() {
        return this.mbTimedOut;
    }

    private void setTimedOut(boolean bl) {
        this.mbTimedOut = bl;
    }

    public boolean executeSynchronously() {
        this.execute();
        return this.waitFor(this.mTimeOut);
    }

    public boolean executeAsynchronously() {
        this.execute();
        return this.isStarted();
    }

    public synchronized void kill() {
        if (!this.isStarted()) {
            return;
        }
        boolean bl = false;
        int n = 1;
        while (n < 3 && !bl) {
            this.proc.destroy();
            try {
                Thread.sleep(5000 * n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                int n2 = this.proc.exitValue();
                if (n2 < 1) {
                    bl = true;
                } else {
                    ++n;
                }
                this.dbg("kill: process closed with exit code " + n2);
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                if (n < 3) {
                    this.dbg("kill: Couldn't close process after " + n + " attempts, trying again");
                }
                ++n;
            }
        }
        this.isStarted = false;
    }

    protected void execute() {
        if (this.isStarted()) {
            throw new RuntimeException("The process handler has already been executed.");
        }
        Runtime runtime = Runtime.getRuntime();
        try {
            if (this.cmdLine == null) {
                this.log.print(utils.getDateTime() + "execute: Starting command from array: ");
                for (int i = 0; i < this.cmdLineArray.length; ++i) {
                    this.log.print(this.cmdLineArray[i]);
                    this.log.print(" ");
                }
                this.proc = runtime.exec(this.cmdLineArray, this.envVars);
            } else if (this.workDir != null) {
                this.log.println(utils.getDateTime() + "execute: Starting command: " + this.cmdLine + " " + this.workDir.getAbsolutePath());
                this.proc = runtime.exec(this.cmdLine, this.envVars, this.workDir);
            } else {
                this.log.println(utils.getDateTime() + "execute: Starting command: " + this.cmdLine);
                this.proc = runtime.exec(this.cmdLine, this.envVars);
            }
            this.isStarted = true;
        }
        catch (IOException iOException) {
            if (this.cmdLine == null) {
                this.log.println(utils.getDateTime() + "execute: The command array can't be started: " + iOException);
            } else {
                this.log.println(utils.getDateTime() + "execute: The command " + this.cmdLine + " can't be started: " + iOException);
            }
            return;
        }
        this.dbg("execute: pump io-streams");
        this.stdout = new Pump(this.proc.getInputStream(), this.log, "out > ");
        this.stderr = new Pump(this.proc.getErrorStream(), this.log, "err > ");
        this.stdIn = new PrintStream(this.proc.getOutputStream());
        this.dbg("execute: flush io-streams");
        this.flushInput();
    }

    public boolean waitFor() {
        return this.waitFor(0L);
    }

    public boolean waitFor(long l) {
        if (this.isFinished()) {
            return true;
        }
        if (!this.isStarted()) {
            return false;
        }
        if (l == 0L) {
            try {
                this.proc.waitFor();
            }
            catch (InterruptedException interruptedException) {
                this.log.println("The process was interrupted: " + interruptedException);
            }
            this.isFinished = true;
            try {
                this.exitValue = this.proc.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {}
        } else {
            try {
                while (!this.isFinished && l > 0L) {
                    this.isFinished = true;
                    Thread.sleep(1000L);
                    l -= 1000L;
                    try {
                        this.exitValue = this.proc.exitValue();
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        this.isFinished = false;
                    }
                }
                if (l < 0L) {
                    this.setTimedOut(true);
                    this.log.println("The process has timed out!");
                }
            }
            catch (InterruptedException interruptedException) {
                this.log.println("The process was interrupted: " + interruptedException);
            }
        }
        if (!this.isFinished) {
            this.log.println("Going to destroy the process!!");
            this.proc.destroy();
            this.log.println("Process has been destroyed!");
        }
        return this.isFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushInput() {
        if (this.stdIn == null) {
            return;
        }
        String string = this.stdInBuff;
        synchronized (string) {
            this.stdIn.print(this.stdInBuff);
            this.stdIn.flush();
            this.stdInBuff = "";
        }
    }

    public String getOutputText() {
        if (this.stdout == null) {
            return "";
        }
        return this.stdout.getStringBuffer();
    }

    public String getErrorText() {
        if (this.stderr == null) {
            return "";
        }
        return this.stderr.getStringBuffer();
    }

    public void printInputText(String string) {
        this.stdInBuff = this.stdInBuff + string;
        this.flushInput();
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public int getExitCode() {
        try {
            this.exitValue = this.proc.exitValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.exitValue;
    }

    public static void shortWait(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("While waiting :" + interruptedException);
        }
    }

    private void dbg(String string) {
        if (this.debug) {
            this.log.println(utils.getDateTime() + "PH." + string);
        }
    }
}

