/*
 * Decompiled with CFR 0.152.
 */
package helper;

import helper.ParameterNotFoundException;
import helper.ProcessHandler;
import java.io.File;
import java.io.PrintWriter;
import lib.TestParameters;
import share.LogWriter;

public class BuildEnvTools {
    private final TestParameters param;
    private final LogWriter log;
    private final boolean mDebug;
    private final String mEnvSet;
    private final String mPlatform;
    private final String mShell;
    private final String mVersion;

    public BuildEnvTools(TestParameters testParameters, LogWriter logWriter) throws ParameterNotFoundException {
        String string;
        this.param = testParameters;
        this.log = logWriter;
        this.mDebug = testParameters.getBool("DebugIsActive");
        boolean bl = false;
        String string2 = "\nERROR: the following parameter must be set before executing the test:\n\n";
        this.mEnvSet = (String)testParameters.get("OOO_EnvSet");
        if (this.mEnvSet == null) {
            string2 = string2 + "OOO_EnvSet\nThis parameter must ponit to the script to create a build environment like '$SRC_ROOT/SolarisX86Env.Set.sh' or '%SRC_ROOT\\winenv.set.sh'\nIn case you are able to use 'setsolar' or 'setcws' just type 'setsolar' value.\n\n ";
            bl = true;
        }
        this.mPlatform = (String)testParameters.get("OperatingSystem");
        if (this.mDebug) {
            logWriter.println("### " + this.mPlatform);
        }
        if (this.mPlatform == null || !this.mPlatform.equals("unxsols") && !this.mPlatform.equalsIgnoreCase("unxsoli") && !this.mPlatform.equals("unxlngi") && !this.mPlatform.equals("wntmsci")) {
            string2 = string2 + "OperatingSystem\nFill this parameter with an operating system like unxsols, unxsoli, unxlngi or wntmsci.  \n\n";
            bl = true;
        }
        this.mShell = (String)testParameters.get("Shell");
        if (this.mShell == null) {
            string2 = string2 + "Shell\nFill this parameter with a shell which can start 'OOO_ENVSET'\n\t/bin/tcsh c:\\myShell\\myShell.exe\n\n";
            bl = true;
        }
        this.mVersion = (String)testParameters.get("Version");
        if (this.mVersion == null) {
            string2 = string2 + "Version\nYou have to fill this parameter with information of the versionto test like 'src680_m243' or 'cws_unoapi'";
            bl = true;
        }
        if ((string = (String)testParameters.get("COMP_ENV")) == null) {
            string2 = string2 + "COMP_ENV\nYou have to fill this parameter with information of the versionof the compiler like unxsols4, unxsoli4, unxlngi6 oder wintmsci12";
            bl = true;
        }
        if (bl) {
            throw new ParameterNotFoundException(string2);
        }
    }

    public ProcessHandler runCommandsInEnvironmentShell(String[] stringArray, File file, boolean bl) {
        String[] stringArray2 = this.getCmdLinesWithCommand(stringArray);
        ProcessHandler processHandler = new ProcessHandler(stringArray2, (PrintWriter)((Object)this.log), file, bl, this.param);
        processHandler.runCommand();
        return processHandler;
    }

    private String getSetSolarCmd() {
        String string = null;
        if (this.mVersion.startsWith("cws_")) {
            string = "setcws " + this.mVersion.substring(4, this.mVersion.length());
        } else {
            String string2 = (String)this.param.get("COMP_ENV");
            String[] stringArray = this.mVersion.split("_");
            string = "setsolar -" + stringArray[0] + " -ver " + stringArray[1] + " -jdk14  -pro " + string2;
        }
        return string;
    }

    public String getEnvCmd() {
        String string = null;
        this.log.println("prepare command for platform " + this.mPlatform);
        string = this.mEnvSet.equals("setsolar") ? this.getSetSolarCmd() : "source " + this.mEnvSet;
        return string;
    }

    public String getSrcRoot() {
        String string = (String)this.param.get("SRC_ROOT");
        if (string == null) {
            String string2 = this.getEnvCmd();
            String[] stringArray = null;
            stringArray = this.mPlatform.equals("wntmsci") ? new String[]{this.mShell, "/C", "" + string2 + " ^ echo SRC_ROOT=%SRC_ROOT"} : new String[]{this.mShell, "-c ", string2 + " ; echo \"SRC_ROOT=$SRC_ROOT\""};
            ProcessHandler processHandler = new ProcessHandler(stringArray, (PrintWriter)((Object)this.log), null, true, this.param);
            processHandler.runCommand();
            if (this.mDebug) {
                this.log.println("---> Output of command:");
                this.log.println(processHandler.getOutputText());
                this.log.println("<--- Output of command:");
                this.log.println("---> Error output of command");
                this.log.println(processHandler.getErrorText());
                this.log.println("<--- Error output of command");
            }
            String string3 = processHandler.getOutputText();
            String[] stringArray2 = string3.split("\n");
            for (int i = 0; i < stringArray2.length; ++i) {
                String string4 = stringArray2[i];
                if (!string4.startsWith("SRC_ROOT")) continue;
                string = this.getEnvValue(string4);
            }
        }
        return string;
    }

    private String[] getCmdLinesWithCommand(String[] stringArray) {
        String string = this.getEnvCmd();
        String[] stringArray2 = null;
        this.log.println("prepare command for platform " + this.mPlatform);
        String string2 = "";
        string2 = this.mPlatform.equals("wntmsci") ? "^" : ";";
        String string3 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string3 = string3 + string2 + stringArray[i];
        }
        stringArray2 = this.mPlatform.equals("wntmsci") ? new String[]{this.mShell, "/C", "\"" + string + string3 + "\""} : new String[]{this.mShell, "-c ", string + string3};
        return stringArray2;
    }

    private String getEnvValue(String string) {
        String[] stringArray = string.split("=");
        return stringArray[1];
    }
}

