/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import convwatch.GlobalLogWriter;
import convwatch.OSHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SimpleFileSemaphore {
    String m_sInternSemaphoreFile;
    File m_aInternSemaphoreFile;
    GlobalLogWriter m_aLog;
    private static boolean SEMAPHORE_SHOULD_EXIST = true;
    private static boolean SEMAPHORE_SHOULD_NOT_EXIST = false;

    public static void sleep(int n) {
        try {
            Thread.sleep(n * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public SimpleFileSemaphore() throws IllegalArgumentException {
        String string;
        if (OSHelper.isWindows()) {
            string = "C:/Temp/ConvwatchOOoSemaphore.txt";
        } else if (OSHelper.isUnix()) {
            string = "/tmp/ConvwatchOOoSemaphore.txt";
        } else {
            this.m_sInternSemaphoreFile = null;
            throw new IllegalArgumentException("Unknown System, can't initialise SimpleFileSemaphore");
        }
        this.m_sInternSemaphoreFile = string;
        this.m_aInternSemaphoreFile = new File(string);
    }

    public File getSemaphoreFile() {
        return this.m_aInternSemaphoreFile;
    }

    public void P(File file) {
        int n = 0;
        boolean bl = true;
        while (bl) {
            if (file.exists()) {
                SimpleFileSemaphore simpleFileSemaphore = this;
                simpleFileSemaphore.m_aLog.get().println("Active wait since " + n + "sec..");
                ++n;
                SimpleFileSemaphore.sleep(1);
                continue;
            }
            SimpleFileSemaphore.sleep(1);
            if (file.exists()) {
                SimpleFileSemaphore simpleFileSemaphore = this;
                simpleFileSemaphore.m_aLog.get().println("ups...");
                continue;
            }
            bl = false;
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.writeByte(1);
            randomAccessFile.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            SimpleFileSemaphore simpleFileSemaphore = this;
            simpleFileSemaphore.m_aLog.get().println("caught: FileNotFoundException");
        }
        catch (IOException iOException) {
            SimpleFileSemaphore simpleFileSemaphore = this;
            simpleFileSemaphore.m_aLog.get().println("caught: IOException");
        }
    }

    public void V(File file) {
        if (file.exists()) {
            file.delete();
        } else {
            SimpleFileSemaphore simpleFileSemaphore = this;
            simpleFileSemaphore.m_aLog.get().println("Could be a problem here? No resource block found.");
        }
    }

    private static void assure(boolean bl, String string) {
        System.out.print(string);
        System.out.print("  ");
        if (bl) {
            System.out.println("ok");
        } else {
            System.out.println("FAILED");
        }
    }

    private static void testSemaphoreFile(SimpleFileSemaphore simpleFileSemaphore, boolean bl) {
        System.out.println("Check if semaphore file exists.");
        File file = simpleFileSemaphore.getSemaphoreFile();
        if (file.exists()) {
            System.out.println("Name is: " + file.getAbsolutePath());
            SimpleFileSemaphore.assure(bl == SEMAPHORE_SHOULD_EXIST, "Semaphore should exist!");
        } else {
            SimpleFileSemaphore.assure(bl == SEMAPHORE_SHOULD_NOT_EXIST, "Semaphore should not exist!");
        }
    }

    public static void main(String[] stringArray) {
        SimpleFileSemaphore simpleFileSemaphore = new SimpleFileSemaphore();
        SimpleFileSemaphore.testSemaphoreFile(simpleFileSemaphore, SEMAPHORE_SHOULD_NOT_EXIST);
        simpleFileSemaphore.P(simpleFileSemaphore.getSemaphoreFile());
        SimpleFileSemaphore.testSemaphoreFile(simpleFileSemaphore, SEMAPHORE_SHOULD_EXIST);
        simpleFileSemaphore.V(simpleFileSemaphore.getSemaphoreFile());
        SimpleFileSemaphore.testSemaphoreFile(simpleFileSemaphore, SEMAPHORE_SHOULD_NOT_EXIST);
    }
}

