/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import com.sun.star.lang.DisposedException;
import com.sun.star.lang.XMultiServiceFactory;
import convwatch.ConvWatchCancelException;
import convwatch.ConvWatchException;
import convwatch.DB;
import convwatch.DirectoryHelper;
import convwatch.EnhancedComplexTestCase;
import convwatch.FileHelper;
import convwatch.GlobalLogWriter;
import convwatch.GraphicalDifferenceCheck;
import convwatch.GraphicalTestArguments;
import helper.OfficeProvider;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;

public class ReferenceBuilder
extends EnhancedComplexTestCase {
    private String m_sInputPath = "";
    private String m_sReferencePath = "";
    private boolean m_bIncludeSubdirectories = true;

    public String getTestObjectName() {
        return "ReferenceBuilder runner";
    }

    public String[] getTestMethodNames() {
        return new String[]{"buildreference"};
    }

    public void before() {
    }

    public void after() {
    }

    void initMember() {
        String string = (String)param.get("DOC_COMPARATOR_INPUT_PATH");
        boolean bl = false;
        String string2 = "";
        if (string == null || string.length() == 0) {
            log.println("Please set input path (path to documents) DOC_COMPARATOR_INPUT_PATH=path.");
            bl = true;
        } else {
            log.println("found DOC_COMPARATOR_INPUT_PATH " + string);
            this.m_sInputPath = string;
        }
        String string3 = (String)param.get("DOC_COMPARATOR_REFERENCE_PATH");
        if (string3 == null || string3.length() == 0) {
            log.println("Please set output path (path to a directory, where the references should stay) DOC_COMPARATOR_REFERENCE_PATH=path.");
            bl = true;
        } else {
            log.println("found DOC_COMPARATOR_REFERENCE_PATH " + string3);
            this.m_sReferencePath = string3;
        }
        if (bl) {
            this.assure("Must quit, Parameter problems.", false);
        }
        if (this.m_sInputPath.startsWith("file:") || this.m_sReferencePath.startsWith("file:")) {
            this.assure("We can't handle file: URL right, use system path instead.", false);
        }
    }

    protected Object[] mustInstalledSoftware() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("perl -version");
        return arrayList.toArray();
    }

    public void buildreference() {
        GlobalLogWriter.set(log);
        String string = (String)param.get("DB_CONNECTION_STRING");
        this.checkEnvironment(this.mustInstalledSoftware());
        GraphicalTestArguments graphicalTestArguments = this.getGraphicalTestArguments();
        if (graphicalTestArguments == null) {
            this.assure("Must quit", false);
        }
        if (graphicalTestArguments.cancelRequest()) {
            return;
        }
        this.initMember();
        DB.init(graphicalTestArguments.getDBInfoString() + "," + string);
        File file = new File(this.m_sInputPath);
        if (file.isDirectory()) {
            String string2 = System.getProperty("file.separator");
            String string3 = file.getAbsolutePath();
            FileFilter fileFilter = graphicalTestArguments.getFileFilter();
            Object[] objectArray = DirectoryHelper.traverse(this.m_sInputPath, graphicalTestArguments.getFileFilter(), graphicalTestArguments.includeSubDirectories());
            for (int i = 0; i < objectArray.length; ++i) {
                String string4 = (String)objectArray[i];
                String string5 = this.m_sReferencePath + string2 + FileHelper.removeFirstDirectorysAndBasenameFrom(string4, this.m_sInputPath);
                log.println("- next file is: ------------------------------");
                log.println(string4);
                log.println(string5);
                if (graphicalTestArguments.checkIfUsableDocumentType(string4)) {
                    this.runGDC(string4, string5);
                }
                if (!graphicalTestArguments.cancelRequest()) {
                    continue;
                }
                break;
            }
        } else if (graphicalTestArguments.checkIfUsableDocumentType(this.m_sInputPath)) {
            this.runGDC(this.m_sInputPath, this.m_sReferencePath);
        }
    }

    void runGDC(String string, String string2) {
        GraphicalTestArguments graphicalTestArguments = this.getGraphicalTestArguments();
        if (!GraphicalDifferenceCheck.isReferenceExists(string, string2, graphicalTestArguments)) {
            Object object;
            OfficeProvider officeProvider = null;
            if (graphicalTestArguments.shouldOfficeStart()) {
                graphicalTestArguments.getPerformance().startTime(3);
                officeProvider = new OfficeProvider();
                object = (XMultiServiceFactory)officeProvider.getManager(param);
                param.put("ServiceFactory", object);
                graphicalTestArguments.getPerformance().stopTime(3);
                long l = graphicalTestArguments.getPerformance().getTime(3);
                graphicalTestArguments = this.getGraphicalTestArguments();
                graphicalTestArguments.getPerformance().setTime(3, l);
            }
            GlobalLogWriter.get().println("Set office watcher");
            object = param.get("Watcher");
            GlobalLogWriter.get().setWatcher(object);
            try {
                log.println("Reference type is " + graphicalTestArguments.getReferenceType());
                DB.source_start();
                GraphicalDifferenceCheck.createOneReferenceFile(string, string2, graphicalTestArguments);
                DB.source_finished();
            }
            catch (ConvWatchCancelException convWatchCancelException) {
                this.assure(convWatchCancelException.getMessage(), false);
                DB.source_failed(convWatchCancelException.getMessage());
            }
            catch (ConvWatchException convWatchException) {
                this.assure(convWatchException.getMessage(), false);
                DB.source_failed(convWatchException.getMessage());
            }
            catch (DisposedException disposedException) {
                this.assure(disposedException.getMessage(), false, true);
                DB.source_failed(disposedException.getMessage());
            }
            if (officeProvider != null) {
                boolean bl = officeProvider.closeExistingOffice(param, true);
                this.assure("Office closed", bl, true);
            }
        } else {
            DB.source_finished();
        }
    }
}

