/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import convwatch.DateHelper;
import convwatch.GlobalLogWriter;
import convwatch.MySQLThread;
import convwatch.ValueNotFoundException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;

public class DBHelper {
    private static String m_sDBServerName;
    private static String m_sDBName;
    private static String m_sDBUser;
    private static String m_sDBPasswd;
    public static final String sComma = ",";
    public static final String sEqual = "=";
    public static final String sAND = " AND ";

    public void SQLinsertValues(Connection connection, String string, String string2, String string3) {
        if (connection == null) {
            GlobalLogWriter.get().println("DB: ERROR: in SQLinsertValues, connection not established.");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ").append(string);
        stringBuffer.append(" (").append(string2).append(")");
        stringBuffer.append(" VALUES (").append(string3).append(")");
        this.ExecSQL(connection, stringBuffer.toString());
    }

    public void SQLupdateValue(Connection connection, String string, String string2, String string3) {
        if (connection == null) {
            GlobalLogWriter.get().println("DB: ERROR: in SQLinsertValues, connection not established.");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ").append(string).append(" SET ").append(string2).append(" WHERE ").append(string3);
        this.ExecSQL(connection, stringBuffer.toString());
    }

    protected synchronized void fillDBConnection(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, sComma, false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("db:")) {
                m_sDBName = string2.substring(3);
                continue;
            }
            if (string2.startsWith("user:")) {
                m_sDBUser = string2.substring(5);
                continue;
            }
            if (string2.startsWith("passwd:")) {
                m_sDBPasswd = string2.substring(7);
                continue;
            }
            if (!string2.startsWith("server:")) continue;
            m_sDBServerName = string2.substring(7);
        }
    }

    public static Connection getMySQLConnection() throws SQLException {
        try {
            Class.forName("org.gjt.mm.mysql.Driver");
            String string = "jdbc:mysql://" + m_sDBServerName + ":3306/" + m_sDBName;
            Connection connection = DriverManager.getConnection(string, m_sDBUser, m_sDBPasswd);
            return connection;
        }
        catch (ClassNotFoundException classNotFoundException) {
            GlobalLogWriter.get().println("DB: Class not found exception caught: " + classNotFoundException.getMessage());
            GlobalLogWriter.get().println("DB: Maybe mysql.jar is not added to the classpath.");
            return null;
        }
    }

    protected synchronized void ExecSQL(Connection connection, String string) {
        MySQLThread mySQLThread = new MySQLThread(connection, string);
        mySQLThread.start();
    }

    public int QueryIntFromSQL(Connection connection, String string, String string2) throws ValueNotFoundException {
        Statement statement = null;
        Object var5_5 = null;
        int n = 0;
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            resultSet.next();
            try {
                n = string2.length() == 0 ? resultSet.getInt(1) : resultSet.getInt(string2);
            }
            catch (SQLException sQLException) {
                String string3 = sQLException.getMessage();
                GlobalLogWriter.get().println("DB: Original SQL error: " + string3);
                throw new ValueNotFoundException("Cant execute SQL: " + string);
            }
        }
        catch (SQLException sQLException) {
            String string4 = sQLException.getMessage();
            GlobalLogWriter.get().println("DB: Couldn't execute sql string " + string + "\n" + string4);
        }
        return n;
    }

    public String Quote(String string) {
        String string2 = "'";
        String string3 = "\"";
        int n = string.indexOf(string2);
        if (n >= 0) {
            return string3 + string + string3;
        }
        return string2 + string + string2;
    }

    public static String today() {
        return DateHelper.getDateString("yyyy-MM-dd");
    }
}

