/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.resourceloader.loader.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jfree.resourceloader.ResourceData;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceLoadingException;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.resourceloader.loader.AbstractResourceData;
import org.jfree.resourceloader.loader.LoaderUtils;

public class ZipResourceData
extends AbstractResourceData {
    private ResourceKey key;

    public ZipResourceData(ResourceKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.key = key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getResourceAsStream(ResourceManager caller) throws ResourceLoadingException {
        ResourceKey parentKey = this.key.getParent();
        ResourceData data = caller.load(parentKey);
        ZipInputStream zin = new ZipInputStream(data.getResourceAsStream(caller));
        try {
            try {
                block7: {
                    ZipEntry zipEntry = zin.getNextEntry();
                    while (zipEntry != null) {
                        if (!zipEntry.getName().equals(this.key.getIdentifier())) {
                            zipEntry = zin.getNextEntry();
                            continue;
                        }
                        break block7;
                    }
                    throw new ResourceLoadingException("The zip-file did not contain the specified entry");
                }
                ZipInputStream zipInputStream = zin;
                return zipInputStream;
            }
            finally {
                zin.close();
            }
        }
        catch (IOException e) {
            throw new ResourceLoadingException("Reading the zip-file failed.", e);
        }
    }

    public Object getAttribute(String key) {
        if (key.equals("filename")) {
            return LoaderUtils.getFileName((String)this.key.getIdentifier());
        }
        return null;
    }

    public ResourceKey getKey() {
        return this.key;
    }

    public long getVersion(ResourceManager caller) throws ResourceLoadingException {
        ResourceKey parentKey = this.key.getParent();
        ResourceData data = caller.load(parentKey);
        return data.getVersion(caller);
    }
}

