/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.resourceloader.loader.resource;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jfree.resourceloader.ResourceData;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceKeyCreationException;
import org.jfree.resourceloader.ResourceLoader;
import org.jfree.resourceloader.ResourceLoadingException;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.resourceloader.loader.LoaderUtils;
import org.jfree.resourceloader.loader.resource.ClassloaderResourceData;

public class ClassloaderResourceLoader
implements ResourceLoader {
    private ResourceManager manager;

    public void setResourceManager(ResourceManager manager) {
        this.manager = manager;
    }

    public boolean isSupportedKey(ResourceKey key) {
        return ClassloaderResourceLoader.class.getName().equals(key.getSchema());
    }

    public ResourceKey createKey(Object value, Map factoryKeys) throws ResourceKeyCreationException {
        String valueString;
        if (value instanceof String && (valueString = (String)value).startsWith("res://")) {
            return new ResourceKey(ClassloaderResourceLoader.class.getName(), value, factoryKeys);
        }
        return null;
    }

    public ResourceKey deriveKey(ResourceKey parent, String path, Map factoryKeys) throws ResourceKeyCreationException {
        HashMap map;
        if (!this.isSupportedKey(parent)) {
            throw new ResourceKeyCreationException("Assertation: Unsupported parent key type");
        }
        String resource = path.startsWith("res://") ? path : (path.startsWith("/") ? "res:/" + path : LoaderUtils.mergePaths((String)parent.getIdentifier(), path));
        if (factoryKeys != null) {
            map = new HashMap();
            map.putAll(parent.getFactoryParameters());
            map.putAll(factoryKeys);
        } else {
            map = parent.getFactoryParameters();
        }
        return new ResourceKey(parent.getSchema(), resource, map);
    }

    public URL toURL(ResourceKey key) {
        return null;
    }

    public ResourceManager getResourceManager() {
        return this.manager;
    }

    public ResourceData load(ResourceKey key) throws ResourceLoadingException {
        if (!this.isSupportedKey(key)) {
            throw new ResourceLoadingException("Key format is not recognized.");
        }
        return new ClassloaderResourceData(key);
    }

    public static String createResourceKey(Class c, String resource) {
        if (c == null) {
            return "res://" + resource;
        }
        String className = c.getName();
        int lastDot = className.lastIndexOf(46);
        if (lastDot < 0) {
            return "res://" + resource;
        }
        String packageName = className.substring(0, lastDot);
        String packagePath = packageName.replace('.', '/');
        return "res://" + packageName + '/' + packagePath;
    }
}

