/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.resourceloader.loader.resource;

import java.io.InputStream;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceLoadingException;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.resourceloader.loader.AbstractResourceData;
import org.jfree.resourceloader.loader.LoaderUtils;
import org.jfree.util.ObjectUtilities;

public class ClassloaderResourceData
extends AbstractResourceData {
    private ResourceKey key;
    private String resourcePath;

    public ClassloaderResourceData(ResourceKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.key = key;
        String rawPath = (String)key.getIdentifier();
        this.resourcePath = rawPath.substring(6);
    }

    public InputStream getResourceAsStream(ResourceManager caller) throws ResourceLoadingException {
        InputStream stream = ObjectUtilities.getResourceAsStream((String)this.resourcePath, (Class)ClassloaderResourceData.class);
        if (stream == null) {
            throw new ResourceLoadingException("Resource is not available: " + this.resourcePath);
        }
        return stream;
    }

    public Object getAttribute(String key) {
        if (key.equals("filename")) {
            return LoaderUtils.getFileName(this.resourcePath);
        }
        return null;
    }

    public long getVersion(ResourceManager caller) throws ResourceLoadingException {
        return 0L;
    }

    public ResourceKey getKey() {
        return this.key;
    }
}

