/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.resourceloader.loader.raw;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jfree.resourceloader.ResourceData;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceKeyCreationException;
import org.jfree.resourceloader.ResourceLoader;
import org.jfree.resourceloader.ResourceLoadingException;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.resourceloader.loader.raw.RawResourceData;

public class RawResourceLoader
implements ResourceLoader {
    private ResourceManager resourceManager;

    public boolean isSupportedKey(ResourceKey key) {
        return RawResourceLoader.class.getName().equals(key.getSchema());
    }

    public ResourceKey createKey(Object value, Map factoryKeys) throws ResourceKeyCreationException {
        if (!(value instanceof byte[])) {
            return null;
        }
        return new ResourceKey(RawResourceLoader.class.getName(), value, factoryKeys);
    }

    public ResourceKey deriveKey(ResourceKey parent, String path, Map factoryKeys) throws ResourceKeyCreationException {
        if (path != null) {
            throw new ResourceKeyCreationException("Unable to derive key for new path.");
        }
        if (!this.isSupportedKey(parent)) {
            throw new ResourceKeyCreationException("Assertation: Unsupported parent key type");
        }
        if (factoryKeys == null) {
            return parent;
        }
        HashMap map = new HashMap();
        map.putAll(parent.getFactoryParameters());
        map.putAll(factoryKeys);
        return new ResourceKey(parent.getSchema(), parent.getIdentifier(), map);
    }

    public URL toURL(ResourceKey key) {
        return null;
    }

    public ResourceData load(ResourceKey key) throws ResourceLoadingException {
        if (!this.isSupportedKey(key)) {
            throw new ResourceLoadingException("The key type is not supported.");
        }
        return new RawResourceData(key);
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void setResourceManager(ResourceManager manager) {
        this.resourceManager = manager;
    }
}

