/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.resourceloader.loader.file;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jfree.resourceloader.ResourceData;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceKeyCreationException;
import org.jfree.resourceloader.ResourceLoader;
import org.jfree.resourceloader.ResourceLoadingException;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.resourceloader.loader.file.FileResourceData;

public class FileResourceLoader
implements ResourceLoader {
    private ResourceManager manager;

    public void setResourceManager(ResourceManager manager) {
        this.manager = manager;
    }

    public ResourceManager getResourceManager() {
        return this.manager;
    }

    public boolean isSupportedKey(ResourceKey key) {
        return FileResourceLoader.class.getName().equals(key.getSchema());
    }

    public ResourceKey createKey(Object value, Map factoryKeys) throws ResourceKeyCreationException {
        File f;
        if (value instanceof File) {
            return new ResourceKey(FileResourceLoader.class.getName(), value, factoryKeys);
        }
        if (value instanceof String && (f = new File(String.valueOf(value))).exists() && f.isFile()) {
            return new ResourceKey(FileResourceLoader.class.getName(), f, factoryKeys);
        }
        return null;
    }

    public ResourceKey deriveKey(ResourceKey parent, String path, Map factoryKeys) throws ResourceKeyCreationException {
        HashMap map;
        File target;
        if (!this.isSupportedKey(parent)) {
            throw new ResourceKeyCreationException("Assertation: Unsupported parent key type");
        }
        if (path != null) {
            File parentResource = (File)parent.getIdentifier();
            target = new File(parentResource.getParentFile(), path);
            if (!target.exists() || !target.isFile()) {
                throw new ResourceKeyCreationException("Malformed value: " + path + " (" + target + ')');
            }
        } else {
            target = (File)parent.getIdentifier();
        }
        if (factoryKeys != null) {
            map = new HashMap();
            map.putAll(parent.getFactoryParameters());
            map.putAll(factoryKeys);
        } else {
            map = parent.getFactoryParameters();
        }
        return new ResourceKey(parent.getSchema(), target, map);
    }

    public URL toURL(ResourceKey key) {
        File file = (File)key.getIdentifier();
        try {
            return file.toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public ResourceData load(ResourceKey key) throws ResourceLoadingException {
        if (!this.isSupportedKey(key)) {
            throw new ResourceLoadingException("Key format is not recognized.");
        }
        return new FileResourceData(key);
    }
}

