/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.resourceloader.loader.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceLoadingException;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.resourceloader.loader.AbstractResourceData;

public class FileResourceData
extends AbstractResourceData {
    private ResourceKey key;
    private File file;

    public FileResourceData(ResourceKey key) throws ResourceLoadingException {
        if (key == null) {
            throw new NullPointerException();
        }
        File file = (File)key.getIdentifier();
        if (!file.isFile()) {
            throw new ResourceLoadingException("File-handle given does not point to a regular file.");
        }
        if (!file.canRead()) {
            throw new ResourceLoadingException("File '" + file + "' is not readable.");
        }
        this.key = key;
        this.file = file;
    }

    public InputStream getResourceAsStream(ResourceManager caller) throws ResourceLoadingException {
        try {
            return new BufferedInputStream(new FileInputStream(this.file));
        }
        catch (FileNotFoundException e) {
            throw new ResourceLoadingException("Unable to open Stream: ", e);
        }
    }

    public Object getAttribute(String attrkey) {
        if (attrkey.equals("filename")) {
            return this.file.getName();
        }
        if (attrkey.equals("content-length")) {
            return new Long(this.file.length());
        }
        return null;
    }

    public long getVersion(ResourceManager caller) throws ResourceLoadingException {
        return this.file.lastModified();
    }

    public ResourceKey getKey() {
        return this.key;
    }
}

