/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.resourceloader.loader;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jfree.resourceloader.ResourceData;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceKeyCreationException;
import org.jfree.resourceloader.ResourceLoader;
import org.jfree.resourceloader.ResourceLoadingException;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.resourceloader.loader.URLResourceData;

public class URLResourceLoader
implements ResourceLoader {
    private ResourceManager manager;

    public void setResourceManager(ResourceManager manager) {
        this.manager = manager;
    }

    public ResourceManager getResourceManager() {
        return this.manager;
    }

    public boolean isSupportedKey(ResourceKey key) {
        return URLResourceLoader.class.getName().equals(key.getSchema());
    }

    public ResourceKey createKey(Object value, Map factoryKeys) throws ResourceKeyCreationException {
        String valueString;
        if (value instanceof URL) {
            return new ResourceKey(URLResourceLoader.class.getName(), value, factoryKeys);
        }
        if (value instanceof String && ((valueString = (String)value).indexOf("://") >= 0 || valueString.startsWith("file:/"))) {
            try {
                return new ResourceKey(URLResourceLoader.class.getName(), new URL(valueString), factoryKeys);
            }
            catch (MalformedURLException mfue) {
                throw new ResourceKeyCreationException("Malformed value: " + value);
            }
        }
        return null;
    }

    public ResourceKey deriveKey(ResourceKey parent, String path, Map factoryKeys) throws ResourceKeyCreationException {
        if (!this.isSupportedKey(parent)) {
            throw new ResourceKeyCreationException("Assertation: Unsupported parent key type");
        }
        try {
            HashMap map;
            URL url = path != null ? new URL((URL)parent.getIdentifier(), path) : (URL)parent.getIdentifier();
            if (factoryKeys != null) {
                map = new HashMap();
                map.putAll(parent.getFactoryParameters());
                map.putAll(factoryKeys);
            } else {
                map = parent.getFactoryParameters();
            }
            return new ResourceKey(parent.getSchema(), url, map);
        }
        catch (MalformedURLException e) {
            throw new ResourceKeyCreationException("Malformed value: " + path);
        }
    }

    public URL toURL(ResourceKey key) {
        return (URL)key.getIdentifier();
    }

    public ResourceData load(ResourceKey key) throws ResourceLoadingException {
        if (!this.isSupportedKey(key)) {
            throw new ResourceLoadingException("Key format is not recognized.");
        }
        return new URLResourceData(key);
    }
}

