/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.resourceloader.loader;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.jfree.io.IOUtils;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceLoadingException;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.resourceloader.loader.AbstractResourceData;

public class URLResourceData
extends AbstractResourceData {
    private long modificationDate;
    private String filename;
    private Long contentLength;
    private String contentType;
    private boolean metaDataOK;
    private URL url;
    private ResourceKey key;

    public URLResourceData(ResourceKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.key = key;
        this.url = (URL)key.getIdentifier();
        this.filename = IOUtils.getInstance().getFileName(this.url);
    }

    private void readMetaData() throws IOException {
        URLConnection c = this.url.openConnection();
        c.setDoOutput(false);
        c.setAllowUserInteraction(false);
        if (c instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)c;
            httpURLConnection.setRequestMethod("HEAD");
        }
        c.connect();
        this.modificationDate = c.getDate();
        this.contentLength = new Long(c.getContentLength());
        this.contentType = c.getHeaderField("content-type");
        c.getInputStream().close();
        this.metaDataOK = true;
    }

    public InputStream getResourceAsStream(ResourceManager caller) throws ResourceLoadingException {
        try {
            URLConnection c = this.url.openConnection();
            c.setDoOutput(false);
            c.setAllowUserInteraction(false);
            return c.getInputStream();
        }
        catch (IOException e) {
            throw new ResourceLoadingException("Failed to open URL connection", e);
        }
    }

    public Object getAttribute(String key) {
        if (key.equals("filename")) {
            return this.filename;
        }
        if (key.equals("content-length")) {
            try {
                if (!this.metaDataOK) {
                    this.readMetaData();
                }
                return this.contentLength;
            }
            catch (IOException e) {
                return null;
            }
        }
        if (key.equals("content-type")) {
            try {
                if (!this.metaDataOK) {
                    this.readMetaData();
                }
                return this.contentType;
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public long getVersion(ResourceManager caller) throws ResourceLoadingException {
        try {
            this.readMetaData();
            return this.modificationDate;
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public ResourceKey getKey() {
        return this.key;
    }
}

