/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.resourceloader.loader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.jfree.io.IOUtils;
import org.jfree.resourceloader.ResourceData;
import org.jfree.resourceloader.ResourceLoadingException;
import org.jfree.resourceloader.ResourceManager;

public abstract class AbstractResourceData
implements ResourceData,
Serializable {
    protected AbstractResourceData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getResource(ResourceManager caller) throws ResourceLoadingException {
        byte[] byArray;
        InputStream in = this.getResourceAsStream(caller);
        if (in == null) {
            throw new ResourceLoadingException("Unable to read Stream: No input stream: " + this.getKey());
        }
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            IOUtils.getInstance().copyStreams(in, (OutputStream)bout);
            byArray = bout.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (ResourceLoadingException rle) {
                throw rle;
            }
            catch (IOException e) {
                throw new ResourceLoadingException("Unable to read Stream: ", e);
            }
        }
        in.close();
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResource(ResourceManager caller, byte[] target, int offset, int length) throws ResourceLoadingException {
        int n;
        if (target == null) {
            throw new NullPointerException();
        }
        if (target.length < offset + length) {
            throw new IndexOutOfBoundsException();
        }
        InputStream in = this.getResourceAsStream(caller);
        if (in == null) {
            throw new ResourceLoadingException("Unable to read Stream: No input stream: " + this.getKey());
        }
        try {
            if (offset > 0) {
                long toBeSkipped = offset;
                long skipResult = in.skip(toBeSkipped);
                toBeSkipped -= skipResult;
                while (skipResult > 0L && toBeSkipped > 0L) {
                    skipResult = in.skip(offset);
                    toBeSkipped -= skipResult;
                }
                if (toBeSkipped > 0L) {
                    throw new ResourceLoadingException("Unable to read Stream: Skipping content failed: " + this.getKey());
                }
            }
            int bytesToRead = length;
            int bytesRead = in.read(target, length - bytesToRead, bytesToRead);
            while (bytesRead > -1 && bytesToRead > 0) {
                bytesRead = in.read(target, length - (bytesToRead -= bytesRead), bytesToRead);
            }
            n = length - bytesRead;
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (ResourceLoadingException rle) {
                throw rle;
            }
            catch (IOException e) {
                throw new ResourceLoadingException("Unable to read Stream: ", e);
            }
        }
        in.close();
        return n;
    }
}

