/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.resourceloader.factory.image;

import java.awt.Image;
import java.awt.Toolkit;
import org.jfree.resourceloader.Resource;
import org.jfree.resourceloader.ResourceData;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceLoadingException;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.resourceloader.SimpleResource;
import org.jfree.resourceloader.factory.AbstractFactoryModule;

public class PNGImageFactoryModule
extends AbstractFactoryModule {
    private static final int[] FINGERPRINT = new int[]{137, 80, 78, 71, 13, 10, 26, 10};
    private static final String[] MIMETYPES = new String[]{"image/png", "application/png", "application/x-png"};
    private static final String[] FILEEXTENSIONS = new String[]{".png"};

    public int getHeaderFingerprintSize() {
        return FINGERPRINT.length;
    }

    protected int[] getFingerPrint() {
        return FINGERPRINT;
    }

    protected String[] getMimeTypes() {
        return MIMETYPES;
    }

    protected String[] getFileExtensions() {
        return FILEEXTENSIONS;
    }

    public Resource create(ResourceManager caller, ResourceData data, ResourceKey context) throws ResourceLoadingException {
        long version = data.getVersion(caller);
        Image image = Toolkit.getDefaultToolkit().createImage(data.getResource(caller));
        return new SimpleResource(data.getKey(), image, version);
    }
}

