/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.resourceloader.factory.image;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import org.jfree.resourceloader.Resource;
import org.jfree.resourceloader.ResourceData;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceLoadingException;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.resourceloader.SimpleResource;
import org.jfree.resourceloader.factory.AbstractFactoryModule;

public class JPEGImageFactoryModule
extends AbstractFactoryModule {
    private static final int[] FINGERPRINT_1 = new int[]{255, 216, 255, 224};
    private static final int[] FINGERPRINT_2 = new int[]{74, 70, 73, 70, 0};
    private static final String[] MIMETYPES = new String[]{"image/jpeg", "image/jpg", "image/jp_", "application/jpg", "application/x-jpg", "image/pjpeg", "image/pipeg", "image/vnd.swiftview-jpeg", "image/x-xbitmap"};
    private static final String[] FILEEXTENSIONS = new String[]{".jpg", ".jpeg"};
    private static final int[] EMPTY_ARRAY = new int[0];

    public int getHeaderFingerprintSize() {
        return -1;
    }

    protected boolean canHandleResourceByContent(InputStream data) throws IOException {
        int i;
        int[] fingerprint = FINGERPRINT_1;
        for (i = 0; i < fingerprint.length; ++i) {
            if (fingerprint[i] == data.read()) continue;
            return false;
        }
        if (data.read() == -1) {
            return false;
        }
        if (data.read() == -1) {
            return false;
        }
        fingerprint = FINGERPRINT_2;
        for (i = 0; i < fingerprint.length; ++i) {
            if (fingerprint[i] == data.read()) continue;
            return false;
        }
        return true;
    }

    protected int[] getFingerPrint() {
        return EMPTY_ARRAY;
    }

    protected String[] getMimeTypes() {
        return MIMETYPES;
    }

    protected String[] getFileExtensions() {
        return FILEEXTENSIONS;
    }

    public Resource create(ResourceManager caller, ResourceData data, ResourceKey context) throws ResourceLoadingException {
        long version = data.getVersion(caller);
        Image image = Toolkit.getDefaultToolkit().createImage(data.getResource(caller));
        return new SimpleResource(data.getKey(), image, version);
    }
}

