/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.resourceloader;

import java.io.Serializable;
import java.util.HashMap;
import org.jfree.resourceloader.Resource;
import org.jfree.resourceloader.ResourceKey;

public class DependencyCollector
implements Serializable,
Cloneable {
    private HashMap dependencies;

    public DependencyCollector(ResourceKey source, long version) {
        if (source == null) {
            throw new NullPointerException();
        }
        this.dependencies = new HashMap();
        this.dependencies.put(source, new Long(version));
    }

    public ResourceKey[] getDependencies() {
        return this.dependencies.keySet().toArray(new ResourceKey[this.dependencies.size()]);
    }

    public void add(Resource dependentResource) {
        ResourceKey[] depKeys = dependentResource.getDependencies();
        for (int i = 0; i < depKeys.length; ++i) {
            ResourceKey depKey = depKeys[i];
            long version = dependentResource.getVersion(depKey);
            this.add(depKey, version);
        }
    }

    public void add(ResourceKey resourceKey, long version) {
        this.dependencies.put(resourceKey, new Long(version));
    }

    public long getVersion(ResourceKey key) {
        Long l = (Long)this.dependencies.get(key);
        if (l == null) {
            return -1L;
        }
        return l;
    }

    public Object clone() throws CloneNotSupportedException {
        DependencyCollector dc = (DependencyCollector)super.clone();
        dc.dependencies = (HashMap)this.dependencies.clone();
        return dc;
    }
}

