/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.resourceloader;

import org.jfree.resourceloader.DependencyCollector;
import org.jfree.resourceloader.Resource;
import org.jfree.resourceloader.ResourceException;
import org.jfree.resourceloader.ResourceKey;

public class CompoundResource
implements Resource {
    private ResourceKey source;
    private DependencyCollector dependencies;
    private Object product;

    public CompoundResource(ResourceKey source, DependencyCollector dependencies, Object product) {
        if (source == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (dependencies == null) {
            throw new NullPointerException("Dependecies must be given.");
        }
        if (product == null) {
            throw new NullPointerException("Product must not be null");
        }
        this.source = source;
        try {
            this.dependencies = (DependencyCollector)dependencies.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone not supported? This should not happen.");
        }
        this.product = product;
    }

    public Object getResource() throws ResourceException {
        return this.product;
    }

    public long getVersion(ResourceKey key) {
        return this.dependencies.getVersion(key);
    }

    public ResourceKey[] getDependencies() {
        return this.dependencies.getDependencies();
    }

    public ResourceKey getSource() {
        return this.source;
    }
}

