/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util.beans;

import java.util.Locale;
import java.util.StringTokenizer;
import org.jfree.report.util.beans.BeanException;
import org.jfree.report.util.beans.ValueConverter;

public class LocaleValueConverter
implements ValueConverter {
    public String toAttributeValue(Object o) throws BeanException {
        Locale l = (Locale)o;
        if ("".equals(l.getCountry())) {
            return l.getLanguage();
        }
        if ("".equals(l.getVariant())) {
            return l.getLanguage() + "_" + l.getCountry();
        }
        return l.getLanguage() + "_" + l.getCountry() + "_" + l.getVariant();
    }

    public Object toPropertyValue(String s) throws BeanException {
        StringTokenizer strtok = new StringTokenizer(s.trim(), "_");
        if (!strtok.hasMoreElements()) {
            throw new BeanException("This is no valid locale specification.");
        }
        String language = strtok.nextToken();
        String country = "";
        if (strtok.hasMoreTokens()) {
            country = strtok.nextToken();
        }
        String variant = "";
        if (strtok.hasMoreTokens()) {
            variant = strtok.nextToken();
        }
        return new Locale(language, country, variant);
    }
}

