/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util.beans;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import org.jfree.report.util.beans.BeanException;
import org.jfree.report.util.beans.BeanUtility;
import org.jfree.report.util.beans.ValueConverter;

public class GenericValueConverter
implements ValueConverter {
    private PropertyDescriptor propertyDescriptor;
    private PropertyEditor propertyEditor;

    public GenericValueConverter(PropertyDescriptor pd) throws IntrospectionException {
        if (pd == null) {
            throw new NullPointerException("PropertyDescriptor must not be null.");
        }
        if (pd.getPropertyEditorClass() == null) {
            throw new IntrospectionException("Property has no editor.");
        }
        this.propertyDescriptor = pd;
        this.propertyEditor = this.createPropertyEditor(pd);
    }

    private PropertyEditor createPropertyEditor(PropertyDescriptor pi) throws IntrospectionException {
        Class<?> c = pi.getPropertyEditorClass();
        try {
            return (PropertyEditor)c.newInstance();
        }
        catch (Exception e) {
            throw new IntrospectionException("Unable to create PropertyEditor.");
        }
    }

    public String toAttributeValue(Object o) throws BeanException {
        if (!BeanUtility.getPropertyType(this.propertyDescriptor).isInstance(o)) {
            throw new ClassCastException("Give me a real type.");
        }
        this.propertyEditor.setValue(o);
        return this.propertyEditor.getAsText();
    }

    public Object toPropertyValue(String s) {
        this.propertyEditor.setAsText(s);
        return this.propertyEditor.getValue();
    }
}

