/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util.beans;

import org.jfree.report.util.CSVTokenizer;
import org.jfree.report.util.PropertyLookupParser;
import org.jfree.report.util.beans.BeanException;
import org.jfree.report.util.beans.ConverterRegistry;

public abstract class BeanPropertyLookupParser
extends PropertyLookupParser {
    protected abstract Object performInitialLookup(String var1);

    protected String lookupVariable(String entity) {
        CSVTokenizer tokenizer = new CSVTokenizer(entity, ".");
        if (tokenizer.hasMoreTokens()) {
            String name = tokenizer.nextToken();
            Object base = this.performInitialLookup(name);
            try {
                if (tokenizer.hasMoreTokens()) {
                    return BeanPropertyLookupParser.continueLookupVariable(tokenizer, base);
                }
                return ConverterRegistry.toAttributeValue(base);
            }
            catch (BeanException e) {
                return entity;
            }
        }
        return entity;
    }

    private static String continueLookupVariable(CSVTokenizer tokenizer, Object parent) throws BeanException {
        if (tokenizer.hasMoreTokens()) {
            String name = tokenizer.nextToken();
            Object base = ConverterRegistry.toPropertyValue(name, parent.getClass());
            if (tokenizer.hasMoreTokens()) {
                return BeanPropertyLookupParser.continueLookupVariable(tokenizer, base);
            }
            return ConverterRegistry.toAttributeValue(base);
        }
        return null;
    }
}

