/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import java.io.Serializable;

public abstract class PropertyLookupParser
implements Serializable {
    private static final int EXPECT_DOLLAR = 0;
    private static final int EXPECT_OPEN_BRACE = 1;
    private static final int EXPECT_CLOSE_BRACE = 2;
    private char markerChar = (char)36;
    private char closingBraceChar = (char)125;
    private char openingBraceChar = (char)123;
    private char escapeChar = (char)92;

    protected PropertyLookupParser() {
    }

    public char getClosingBraceChar() {
        return this.closingBraceChar;
    }

    public void setClosingBraceChar(char closingBraceChar) {
        this.closingBraceChar = closingBraceChar;
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public void setEscapeChar(char escapeChar) {
        this.escapeChar = escapeChar;
    }

    public char getOpeningBraceChar() {
        return this.openingBraceChar;
    }

    public void setOpeningBraceChar(char openingBraceChar) {
        this.openingBraceChar = openingBraceChar;
    }

    public char getMarkerChar() {
        return this.markerChar;
    }

    public void setMarkerChar(char markerChar) {
        this.markerChar = markerChar;
    }

    public String translateAndLookup(String value) {
        if (value == null) {
            return null;
        }
        char[] chars = value.toCharArray();
        StringBuffer result = new StringBuffer(chars.length);
        boolean haveEscape = false;
        int state = 0;
        StringBuffer propertyName = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (haveEscape) {
                haveEscape = false;
                if (state == 2) {
                    propertyName.append(c);
                    continue;
                }
                result.append(c);
                continue;
            }
            if (state == 0 && c == this.markerChar) {
                state = 1;
                continue;
            }
            if (state == 1) {
                if (c == this.openingBraceChar) {
                    state = 2;
                    continue;
                }
                result.append(this.markerChar);
                state = 0;
            }
            if (state == 2 && c == this.closingBraceChar) {
                String s = this.lookupVariable(propertyName.toString());
                if (s == null) {
                    result.append(this.markerChar);
                    result.append(this.openingBraceChar);
                    result.append(propertyName);
                    result.append(this.closingBraceChar);
                } else {
                    result.append(s);
                }
                propertyName.delete(0, propertyName.length());
                state = 0;
                continue;
            }
            if (c == this.escapeChar) {
                haveEscape = true;
                continue;
            }
            if (state == 2) {
                propertyName.append(c);
                continue;
            }
            result.append(c);
        }
        if (state >= 1) {
            result.append(this.markerChar);
            if (state >= 2) {
                result.append(this.openingBraceChar);
                result.append(propertyName);
            }
        }
        return result.toString();
    }

    protected abstract String lookupVariable(String var1);
}

