/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import java.io.IOException;
import java.io.Writer;

public class MemoryStringWriter
extends Writer {
    private int bufferIncrement;
    private int cursor;
    private char[] buffer;

    public MemoryStringWriter() {
        this(4096);
    }

    public MemoryStringWriter(int bufferSize) {
        this.bufferIncrement = bufferSize;
        this.buffer = new char[bufferSize];
    }

    public synchronized void write(char[] cbuf, int off, int len) throws IOException {
        if (len < 0) {
            throw new IllegalArgumentException();
        }
        if (off < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (cbuf == null) {
            throw new NullPointerException();
        }
        if (len + off > cbuf.length) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureSize(this.cursor + len);
        System.arraycopy(cbuf, off, this.buffer, this.cursor, len);
        this.cursor += len;
    }

    private void ensureSize(int size) {
        if (this.buffer.length >= size) {
            return;
        }
        int newSize = Math.max(size, this.buffer.length + this.bufferIncrement);
        char[] newBuffer = new char[newSize];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.cursor);
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
    }

    public String toString() {
        return new String(this.buffer, 0, this.cursor);
    }
}

