/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class CSVTokenizer
implements Enumeration {
    private String record;
    private String separator;
    private String quate;
    private int currentIndex;
    private boolean beforeStart;
    public static final String SEPARATOR_COMMA = ",";
    public static final String SEPARATOR_TAB = "\t";
    public static final String SEPARATOR_SPACE = " ";
    public static final String DOUBLE_QUATE = "\"";
    public static final String SINGLE_QUATE = "'";

    public CSVTokenizer(String aString, String theSeparator, String theQuate) {
        if (aString == null) {
            throw new NullPointerException("The given string is null");
        }
        if (theSeparator == null) {
            throw new NullPointerException("The given separator is null");
        }
        if (theQuate == null) {
            throw new NullPointerException("The given quate is null");
        }
        this.record = aString.trim();
        this.separator = theSeparator;
        this.quate = theQuate;
        this.currentIndex = 0;
        this.beforeStart = true;
    }

    public CSVTokenizer(String aString, String theSeparator) {
        this(aString, theSeparator, DOUBLE_QUATE);
    }

    public CSVTokenizer(String aString) {
        this(aString, SEPARATOR_COMMA);
    }

    public boolean hasMoreTokens() {
        return this.currentIndex < this.record.length();
    }

    public String nextToken() throws NoSuchElementException, IllegalArgumentException {
        if (!this.hasMoreTokens()) {
            throw new NoSuchElementException();
        }
        if (!this.beforeStart) {
            this.currentIndex += this.separator.length();
        } else {
            this.beforeStart = false;
        }
        StringBuffer token = new StringBuffer();
        if (this.record.startsWith(this.quate, this.currentIndex)) {
            int end;
            String rec = this.record.substring(this.currentIndex + this.quate.length());
            token.delete(0, token.length());
            while (true) {
                if ((end = rec.indexOf(this.quate)) < 0) {
                    throw new IllegalArgumentException("Illegal format");
                }
                if (!rec.startsWith(this.quate, end + 1)) break;
                token.append(rec.substring(0, end + 1));
                rec = rec.substring(end + this.quate.length() * 2);
                ++this.currentIndex;
            }
            token.append(rec.substring(0, end));
            this.currentIndex += token.length() + this.quate.length() * 2;
        } else {
            int end = this.record.indexOf(this.separator, this.currentIndex);
            if (end >= 0) {
                int start = this.currentIndex;
                token.delete(0, token.length());
                token.append(this.record.substring(start, end));
                this.currentIndex = end;
            } else {
                int start = this.currentIndex;
                token.delete(0, token.length());
                token.append(this.record.substring(start));
                this.currentIndex = this.record.length();
            }
        }
        return token.toString();
    }

    public String nextToken(String theSeparator) {
        this.separator = theSeparator;
        return this.nextToken();
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public int countTokens() {
        int count = 0;
        int preserve = this.currentIndex;
        boolean preserveStart = this.beforeStart;
        while (this.hasMoreTokens()) {
            this.nextToken();
            ++count;
        }
        this.currentIndex = preserve;
        this.beforeStart = preserveStart;
        return count;
    }

    public String getQuate() {
        return this.quate;
    }

    public void setQuate(String quate) {
        this.quate = quate;
    }
}

