/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jfree.report.flow.FlowControlOperation;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Node;
import org.jfree.util.ObjectUtilities;

public class Section
extends Element {
    private static final Node[] EMPTY_ARRAY = new Node[0];
    private static final FlowControlOperation[] EMPTY_FLOWCONTROL = new FlowControlOperation[0];
    private ArrayList allElements;
    private transient Node[] allElementsCached;
    private ArrayList operationsBefore;
    private ArrayList operationsAfter;
    private transient FlowControlOperation[] operationsBeforeCached;
    private transient FlowControlOperation[] operationsAfterCached;
    private boolean repeat;

    public Section() {
        this.setType("section");
        this.allElements = new ArrayList();
    }

    public void addNode(Node element) {
        this.addNode(this.allElements.size(), element);
    }

    public void addNode(int position, Node element) {
        Node parent;
        if (position < 0) {
            throw new IllegalArgumentException("Position < 0");
        }
        if (position > this.allElements.size()) {
            throw new IllegalArgumentException("Position < 0");
        }
        if (element == null) {
            throw new NullPointerException("Band.addElement(...): element is null.");
        }
        if (element instanceof Section) {
            for (Node band = this; band != null; band = band.getParent()) {
                if (band != element) continue;
                throw new IllegalArgumentException("adding container's parent to itself");
            }
        }
        if ((parent = element.getParent()) != null) {
            if (parent == this) {
                return;
            }
            if (parent instanceof Section) {
                Section section = (Section)parent;
                section.removeNode(element);
            } else {
                element.setParent(null);
            }
        }
        this.allElements.add(position, element);
        this.allElementsCached = null;
        element.setParent(this);
    }

    public void addNodes(Collection elements) {
        if (elements == null) {
            throw new NullPointerException("Band.addElements(...): collection is null.");
        }
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            this.addNode(element);
        }
    }

    public Element getElementByName(String name) {
        if (name == null) {
            throw new NullPointerException("Band.getElement(...): name is null.");
        }
        Node[] elements = this.getNodeArray();
        int elementsSize = elements.length;
        for (int i = 0; i < elementsSize; ++i) {
            Element element;
            String elementName;
            Node e = elements[i];
            if (!(e instanceof Element) || (elementName = (element = (Element)e).getName()) == null || !elementName.equals(name)) continue;
            return element;
        }
        return null;
    }

    public void removeNode(Node e) {
        if (e == null) {
            throw new NullPointerException();
        }
        if (e.getParent() != this) {
            return;
        }
        e.setParent(null);
        this.allElements.remove(e);
        this.allElementsCached = null;
    }

    public List getNodes() {
        return Collections.unmodifiableList(this.allElements);
    }

    public int getNodeCount() {
        return this.allElements.size();
    }

    public Node[] getNodeArray() {
        if (this.allElementsCached == null) {
            if (this.allElements.isEmpty()) {
                this.allElementsCached = EMPTY_ARRAY;
            } else {
                Node[] elements = new Node[this.allElements.size()];
                elements = this.allElements.toArray(elements);
                this.allElementsCached = elements;
            }
        }
        return this.allElementsCached;
    }

    public Node getNode(int index) {
        if (this.allElementsCached == null) {
            if (this.allElements.isEmpty()) {
                this.allElementsCached = EMPTY_ARRAY;
            } else {
                Node[] elements = new Node[this.allElements.size()];
                elements = this.allElements.toArray(elements);
                this.allElementsCached = elements;
            }
        }
        return this.allElementsCached[index];
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.getClass().getName());
        b.append("={name=\"");
        b.append(this.getName());
        b.append("\", namespace=\"");
        b.append(this.getNamespace());
        b.append("\", type=\"");
        b.append(this.getType());
        b.append("\", size=\"");
        b.append(this.allElements.size());
        b.append("\"}");
        return b.toString();
    }

    public FlowControlOperation[] getOperationBefore() {
        if (this.operationsBefore == null) {
            return EMPTY_FLOWCONTROL;
        }
        if (this.operationsBeforeCached == null) {
            this.operationsBeforeCached = this.operationsBefore.toArray(EMPTY_FLOWCONTROL);
        }
        return this.operationsBeforeCached;
    }

    public FlowControlOperation[] getOperationAfter() {
        if (this.operationsAfter == null) {
            return EMPTY_FLOWCONTROL;
        }
        if (this.operationsAfterCached == null) {
            this.operationsAfterCached = this.operationsAfter.toArray(EMPTY_FLOWCONTROL);
        }
        return this.operationsAfterCached;
    }

    public void setOperationBefore(FlowControlOperation[] before) {
        if (this.operationsBefore == null) {
            this.operationsBefore = new ArrayList(before.length);
        } else {
            this.operationsBefore.clear();
            this.operationsBefore.ensureCapacity(before.length);
        }
        for (int i = 0; i < before.length; ++i) {
            this.operationsBefore.add(before[i]);
        }
        this.operationsBeforeCached = (FlowControlOperation[])before.clone();
    }

    public void setOperationAfter(FlowControlOperation[] ops) {
        if (this.operationsAfter == null) {
            this.operationsAfter = new ArrayList(ops.length);
        } else {
            this.operationsAfter.clear();
            this.operationsAfter.ensureCapacity(ops.length);
        }
        for (int i = 0; i < ops.length; ++i) {
            this.operationsAfter.add(ops[i]);
        }
        this.operationsAfterCached = (FlowControlOperation[])ops.clone();
    }

    public void addOperationAfter(FlowControlOperation op) {
        if (this.operationsAfter == null) {
            this.operationsAfter = new ArrayList();
        }
        this.operationsAfter.add(op);
        this.operationsAfterCached = null;
    }

    public void addOperationBefore(FlowControlOperation op) {
        if (this.operationsBefore == null) {
            this.operationsBefore = new ArrayList();
        }
        this.operationsBefore.add(op);
        this.operationsBeforeCached = null;
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    public Element findFirstChild(String uri, String tagName) {
        Node[] nodes = this.getNodeArray();
        for (int i = 0; i < nodes.length; ++i) {
            Element e;
            Node node = nodes[i];
            if (!(node instanceof Element) || !ObjectUtilities.equal((Object)uri, (Object)(e = (Element)node).getNamespace()) || !ObjectUtilities.equal((Object)tagName, (Object)e.getType())) continue;
            return e;
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        Section section = (Section)super.clone();
        if (this.operationsAfter != null) {
            section.operationsAfter = (ArrayList)this.operationsAfter.clone();
        }
        if (this.operationsBefore != null) {
            section.operationsBefore = (ArrayList)this.operationsBefore.clone();
        }
        section.allElements = (ArrayList)this.allElements.clone();
        section.allElements.clear();
        int elementSize = this.allElements.size();
        if (this.allElementsCached != null) {
            section.allElementsCached = (Node[])this.allElementsCached.clone();
            for (int i = 0; i < this.allElementsCached.length; ++i) {
                Node eC = (Node)this.allElementsCached[i].clone();
                section.allElements.add(eC);
                section.allElementsCached[i] = eC;
                eC.setParent(section);
            }
        } else {
            for (int i = 0; i < elementSize; ++i) {
                Node e = (Node)this.allElements.get(i);
                Node eC = (Node)e.clone();
                section.allElements.add(eC);
                eC.setParent(section);
            }
        }
        return section;
    }
}

